/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.constraint;

import jakarta.data.constraint.Constraint;
import jakarta.data.constraint.LikeRecord;
import jakarta.data.constraint.NotLikeRecord;
import jakarta.data.expression.TextExpression;
import jakarta.data.messages.Messages;
import jakarta.data.spi.expression.literal.StringLiteral;

public interface NotLike
extends Constraint<String> {
    public char escape();

    public static NotLike literal(String value) {
        Messages.requireNonNull(value, "value");
        StringLiteral expression = StringLiteral.of(LikeRecord.escape(value));
        return new NotLikeRecord(expression, '\\');
    }

    public TextExpression<?> pattern();

    public static NotLike pattern(String pattern) {
        return NotLike.pattern(pattern, '_', '%');
    }

    public static NotLike pattern(String pattern, char charWildcard, char stringWildcard) {
        Messages.requireNonNull(pattern, "pattern");
        StringLiteral expression = StringLiteral.of(LikeRecord.translate(pattern, charWildcard, stringWildcard, '\\', false));
        return new NotLikeRecord(expression, '\\');
    }

    public static NotLike pattern(String pattern, char charWildcard, char stringWildcard, char escape) {
        Messages.requireNonNull(pattern, "pattern");
        StringLiteral expression = StringLiteral.of(LikeRecord.translate(pattern, charWildcard, stringWildcard, escape, true));
        return new NotLikeRecord(expression, escape);
    }

    public static NotLike pattern(TextExpression<?> pattern, char escape) {
        Messages.requireNonNull(pattern, "pattern");
        return new NotLikeRecord(pattern, escape);
    }

    public static NotLike prefix(String prefix) {
        Messages.requireNonNull(prefix, "prefix");
        StringLiteral expression = StringLiteral.of(LikeRecord.escape(prefix) + "%");
        return new NotLikeRecord(expression, '\\');
    }

    public static NotLike substring(String substring) {
        Messages.requireNonNull(substring, "substring");
        StringLiteral expression = StringLiteral.of("%" + LikeRecord.escape(substring) + "%");
        return new NotLikeRecord(expression, '\\');
    }

    public static NotLike suffix(String suffix) {
        Messages.requireNonNull(suffix, "suffix");
        StringLiteral expression = StringLiteral.of("%" + LikeRecord.escape(suffix));
        return new NotLikeRecord(expression, '\\');
    }
}

