/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.constraint;

import jakarta.data.constraint.Constraint;
import jakarta.data.constraint.InRecord;
import jakarta.data.expression.Expression;
import jakarta.data.messages.Messages;
import jakarta.data.spi.expression.literal.Literal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface In<V>
extends Constraint<V> {
    public List<Expression<?, V>> expressions();

    public static <V> In<V> values(Collection<V> values) {
        Messages.requireNonNull(values, "values");
        if (values.isEmpty()) {
            throw new IllegalArgumentException(Messages.get("002.no.elements", "values"));
        }
        ArrayList<Literal<V>> expressions = new ArrayList<Literal<V>>(values.size());
        for (V value : values) {
            if (value == null) {
                throw new NullPointerException(Messages.get("003.null.element", "values"));
            }
            expressions.add(Literal.of(value));
        }
        return new InRecord(Collections.unmodifiableList(expressions));
    }

    @SafeVarargs
    public static <V> In<V> expressions(Expression<?, V> ... expressions) {
        Messages.requireNonNull(expressions, "expressions");
        if (expressions.length == 0) {
            throw new IllegalArgumentException(Messages.get("002.no.elements", "expressions"));
        }
        for (Expression<?, V> expression : expressions) {
            if (expression != null) continue;
            throw new NullPointerException(Messages.get("003.null.element", "expressions"));
        }
        return new InRecord<V>(List.of(expressions));
    }

    public static <V> In<V> expressions(List<Expression<?, V>> expressions) {
        Messages.requireNonNull(expressions, "expressions");
        if (expressions.isEmpty()) {
            throw new IllegalArgumentException(Messages.get("002.no.elements", "expressions"));
        }
        for (Expression<?, V> expression : expressions) {
            if (expression != null) continue;
            throw new NullPointerException(Messages.get("003.null.element", "expressions"));
        }
        return new InRecord<V>(List.copyOf(expressions));
    }

    @SafeVarargs
    public static <V> In<V> values(V ... values) {
        Messages.requireNonNull(values, "values");
        if (values.length == 0) {
            throw new IllegalArgumentException(Messages.get("002.no.elements", "values"));
        }
        ArrayList<Literal<V>> expressions = new ArrayList<Literal<V>>(values.length);
        for (V value : values) {
            if (value == null) {
                throw new NullPointerException(Messages.get("003.null.element", "values"));
            }
            expressions.add(Literal.of(value));
        }
        return new InRecord(Collections.unmodifiableList(expressions));
    }
}

