/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.constraint;

import jakarta.data.constraint.AtLeast;
import jakarta.data.constraint.AtMost;
import jakarta.data.constraint.Between;
import jakarta.data.constraint.EqualTo;
import jakarta.data.constraint.GreaterThan;
import jakarta.data.constraint.In;
import jakarta.data.constraint.LessThan;
import jakarta.data.constraint.Like;
import jakarta.data.constraint.NotBetween;
import jakarta.data.constraint.NotEqualTo;
import jakarta.data.constraint.NotIn;
import jakarta.data.constraint.NotLike;
import jakarta.data.constraint.NotNull;
import jakarta.data.constraint.Null;
import java.util.Set;

public interface Constraint<V> {
    public static <V extends Comparable<?>> Between<V> between(V minimum, V maximum) {
        return Between.bounds(minimum, maximum);
    }

    public static <V> EqualTo<V> equalTo(V value) {
        return EqualTo.value(value);
    }

    public static <V extends Comparable<?>> GreaterThan<V> greaterThan(V bound) {
        return GreaterThan.bound(bound);
    }

    public static <V extends Comparable<?>> AtLeast<V> greaterThanEqual(V minimum) {
        return AtLeast.min(minimum);
    }

    public static <V> In<V> in(Set<V> values) {
        return In.values(values);
    }

    @SafeVarargs
    public static <V> In<V> in(V ... values) {
        return In.values(values);
    }

    public static <V> Null<V> isNull() {
        return Null.instance();
    }

    public static <V extends Comparable<?>> LessThan<V> lessThan(V bound) {
        return LessThan.bound(bound);
    }

    public static <V extends Comparable<?>> AtMost<V> lessThanEqual(V maximum) {
        return AtMost.max(maximum);
    }

    public static Like like(String pattern) {
        return Like.pattern(pattern);
    }

    public static Like like(String pattern, char charWildcard, char stringWildcard) {
        return Like.pattern(pattern, charWildcard, stringWildcard);
    }

    public static Like like(String pattern, char charWildcard, char stringWildcard, char escape) {
        return Like.pattern(pattern, charWildcard, stringWildcard, escape);
    }

    public Constraint<V> negate();

    public static <V extends Comparable<?>> NotBetween<V> notBetween(V lowerBound, V upperBound) {
        return NotBetween.bounds(lowerBound, upperBound);
    }

    public static <V> NotEqualTo<V> notEqualTo(V value) {
        return NotEqualTo.value(value);
    }

    public static <V> NotIn<V> notIn(Set<V> values) {
        return NotIn.values(values);
    }

    @SafeVarargs
    public static <V> NotIn<V> notIn(V ... values) {
        return NotIn.values(values);
    }

    public static NotLike notLike(String pattern) {
        return NotLike.pattern(pattern);
    }

    public static NotLike notLike(String pattern, char charWildcard, char stringWildcard) {
        return NotLike.pattern(pattern, charWildcard, stringWildcard);
    }

    public static NotLike notLike(String pattern, char charWildcard, char stringWildcard, char escape) {
        return NotLike.pattern(pattern, charWildcard, stringWildcard, escape);
    }

    public static <V> NotNull<V> notNull() {
        return NotNull.instance();
    }
}

