/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.http.impl.nio.reactor.AbstractMultiworkerIOReactor;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.impl.nio.reactor.SessionRequestHandle;
import org.apache.http.impl.nio.reactor.SessionRequestImpl;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Asserts;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultConnectingIOReactor
extends AbstractMultiworkerIOReactor
implements ConnectingIOReactor {
    private final Queue<SessionRequestImpl> requestQueue = new ConcurrentLinkedQueue();
    private long lastTimeoutCheck = System.currentTimeMillis();

    public DefaultConnectingIOReactor(IOReactorConfig config, ThreadFactory threadFactory) throws IOReactorException {
        super(config, threadFactory);
    }

    public DefaultConnectingIOReactor(IOReactorConfig config) throws IOReactorException {
        this(config, null);
    }

    public DefaultConnectingIOReactor() throws IOReactorException {
        this(null, null);
    }

    @Deprecated
    public DefaultConnectingIOReactor(int workerCount, ThreadFactory threadFactory, HttpParams params) throws IOReactorException {
        this(DefaultConnectingIOReactor.convert((int)workerCount, (HttpParams)params), threadFactory);
    }

    @Deprecated
    public DefaultConnectingIOReactor(int workerCount, HttpParams params) throws IOReactorException {
        this(DefaultConnectingIOReactor.convert((int)workerCount, (HttpParams)params), null);
    }

    protected void cancelRequests() throws IOReactorException {
        SessionRequestImpl request;
        while ((request = (SessionRequestImpl)this.requestQueue.poll()) != null) {
            request.cancel();
        }
    }

    protected void processEvents(int readyCount) throws IOReactorException {
        long currentTime;
        this.processSessionRequests();
        if (readyCount > 0) {
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            for (SelectionKey key : selectedKeys) {
                this.processEvent(key);
            }
            selectedKeys.clear();
        }
        if ((currentTime = System.currentTimeMillis()) - this.lastTimeoutCheck >= this.selectTimeout) {
            this.lastTimeoutCheck = currentTime;
            Set<SelectionKey> keys = this.selector.keys();
            this.processTimeouts(keys);
        }
    }

    private void processEvent(SelectionKey key) {
        block8: {
            try {
                if (!key.isConnectable()) break block8;
                SocketChannel channel = (SocketChannel)key.channel();
                SessionRequestHandle requestHandle = (SessionRequestHandle)key.attachment();
                SessionRequestImpl sessionRequest = requestHandle.getSessionRequest();
                try {
                    channel.finishConnect();
                }
                catch (IOException ex) {
                    sessionRequest.failed(ex);
                }
                key.cancel();
                key.attach(null);
                if (!sessionRequest.isCompleted()) {
                    this.addChannel(new ChannelEntry(channel, sessionRequest));
                } else {
                    try {
                        channel.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            catch (CancelledKeyException ex) {
                SessionRequestImpl sessionRequest;
                SessionRequestHandle requestHandle = (SessionRequestHandle)key.attachment();
                key.attach(null);
                if (requestHandle == null || (sessionRequest = requestHandle.getSessionRequest()) == null) break block8;
                sessionRequest.cancel();
            }
        }
    }

    private void processTimeouts(Set<SelectionKey> keys) {
        long now = System.currentTimeMillis();
        for (SelectionKey key : keys) {
            SessionRequestHandle handle;
            SessionRequestImpl sessionRequest;
            int timeout;
            Object attachment = key.attachment();
            if (!(attachment instanceof SessionRequestHandle) || (timeout = (sessionRequest = (handle = (SessionRequestHandle)key.attachment()).getSessionRequest()).getConnectTimeout()) <= 0 || handle.getRequestTime() + (long)timeout >= now) continue;
            sessionRequest.timeout();
        }
    }

    public SessionRequest connect(SocketAddress remoteAddress, SocketAddress localAddress, Object attachment, SessionRequestCallback callback) {
        Asserts.check((this.status.compareTo((Enum)IOReactorStatus.ACTIVE) <= 0 ? 1 : 0) != 0, (String)"I/O reactor has been shut down");
        SessionRequestImpl sessionRequest = new SessionRequestImpl(remoteAddress, localAddress, attachment, callback);
        sessionRequest.setConnectTimeout(this.config.getConnectTimeout());
        this.requestQueue.add(sessionRequest);
        this.selector.wakeup();
        return sessionRequest;
    }

    private void validateAddress(SocketAddress address) throws UnknownHostException {
        InetSocketAddress endpoint;
        if (address == null) {
            return;
        }
        if (address instanceof InetSocketAddress && (endpoint = (InetSocketAddress)address).isUnresolved()) {
            throw new UnknownHostException(endpoint.getHostName());
        }
    }

    private void processSessionRequests() throws IOReactorException {
        SessionRequestImpl request;
        while ((request = (SessionRequestImpl)this.requestQueue.poll()) != null) {
            SocketChannel socketChannel;
            if (request.isCompleted()) continue;
            try {
                socketChannel = SocketChannel.open();
            }
            catch (IOException ex) {
                request.failed(ex);
                return;
            }
            try {
                boolean connected;
                this.validateAddress(request.getLocalAddress());
                this.validateAddress(request.getRemoteAddress());
                socketChannel.configureBlocking(false);
                this.prepareSocket(socketChannel.socket());
                if (request.getLocalAddress() != null) {
                    Socket sock = socketChannel.socket();
                    sock.setReuseAddress(this.config.isSoReuseAddress());
                    sock.bind(request.getLocalAddress());
                }
                SocketAddress targetAddress = request.getRemoteAddress();
                try {
                    connected = (Boolean)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (PrivilegedActionException e) {
                    Asserts.check((boolean)(e.getCause() instanceof IOException), (String)("method contract violation only checked exceptions are wrapped: " + e.getCause()));
                    throw (IOException)e.getCause();
                }
                if (connected) {
                    ChannelEntry entry = new ChannelEntry(socketChannel, request);
                    this.addChannel(entry);
                    continue;
                }
            }
            catch (IOException ex) {
                DefaultConnectingIOReactor.closeChannel((Channel)socketChannel);
                request.failed(ex);
                return;
            }
            catch (SecurityException ex) {
                DefaultConnectingIOReactor.closeChannel((Channel)socketChannel);
                request.failed(new IOException(ex));
                return;
            }
            SessionRequestHandle requestHandle = new SessionRequestHandle(request);
            try {
                SelectionKey key = socketChannel.register(this.selector, 8, requestHandle);
                request.setKey(key);
            }
            catch (IOException ex) {
                DefaultConnectingIOReactor.closeChannel((Channel)socketChannel);
                throw new IOReactorException("Failure registering channel with the selector", (Exception)ex);
            }
        }
    }
}

