/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import com.google.common.base.Function;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;

public abstract class AbstractMessageChannelSecurity<MessageType>
extends AbstractMessageHandler<MessageType> {
    @Nonnull
    private Function<MessageContext, BaseContext> parentContextLookupStrategy = new Function<MessageContext, BaseContext>(){

        @Nullable
        public BaseContext apply(@Nullable MessageContext input) {
            return input;
        }
    };
    @Nullable
    private BaseContext parentContext;

    public void setParentContextLookupStrategy(@Nonnull Function<MessageContext, BaseContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.parentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Parent context lookup strategy cannot be null");
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.parentContext = (BaseContext)this.parentContextLookupStrategy.apply((Object)messageContext);
        if (this.parentContext != null) {
            return super.doPreInvoke(messageContext);
        }
        return false;
    }

    protected BaseContext getParentContext() {
        return this.parentContext;
    }
}

