/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.rest;

import com.ibm.ws.jbatch.utility.rest.JsonHelper;
import java.util.ArrayList;
import java.util.List;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobInstance;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;

public class JobInstanceModel
implements JobInstance {
    private JsonObject jsonObject;

    public JobInstanceModel(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public long getInstanceId() {
        return this.jsonObject.getJsonNumber("instanceId").longValue();
    }

    public String getJobName() {
        return this.jsonObject.getString("jobName", "");
    }

    public String getAppName() {
        return this.jsonObject.getString("appName", "");
    }

    public String getSubmitter() {
        return this.jsonObject.getString("submitter", "");
    }

    public BatchStatus getBatchStatus() {
        return JsonHelper.valueOfBatchStatus(this.jsonObject.getString("batchStatus", null));
    }

    public JsonArray getLinks() {
        return this.jsonObject.getJsonArray("_links");
    }

    public List<String> getJobExecutionLinks() {
        ArrayList<String> retMe = new ArrayList<String>();
        for (JsonValue jsonValue : this.getLinks()) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            if (!jsonObject.getString("rel").equals("job execution")) continue;
            retMe.add(jsonObject.getString("href"));
        }
        return retMe;
    }

    public String toString() {
        return JsonHelper.removeFields(this.jsonObject, "_links").toString();
    }
}

