/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.service.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.wsat.components.WSATConfigService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.service.Handler;
import com.ibm.ws.wsat.service.WSATUtil;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.xml.soap.SOAPException;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.wsat.service.wsatconfigservice", immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class WSATConfigServiceImpl
implements WSATConfigService {
    private static final TraceComponent TC = Tr.register(WSATConfigServiceImpl.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    public static final String ASYNC_RESPONSE_TIMEOUT_PROPERTY = "com.ibm.ws.wsat.asyncResponseTimeout";
    public static final Long ASYNC_RESPONSE_TIMEOUT = AccessController.doPrivileged(new PrivilegedAction<Long>(){
        static final long serialVersionUID = -1516527410473067940L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Long run() {
            return Long.getLong(WSATConfigServiceImpl.ASYNC_RESPONSE_TIMEOUT_PROPERTY);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.service.impl.WSATConfigServiceImpl$1", 1.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
        }
    });
    private static final String SSLEnabled = "sslEnabled";
    private static final String clientAuthRef = "clientAuth";
    private static final String SSLRef = "sslRef";
    private static final String proxyRef = "externalURLPrefix";
    private static final String asyncResponseTimeoutRef = "asyncResponseTimeout";
    private static final String WSATContextRoot = "/ibm/wsatservice";
    private static final String HTTPCONFIGSERVICE_REFERENCE_NAME = "httpOptions";
    private static final String WSATHANDLERSERVICE_REFERENCE_NAME = "handler";
    private static final AtomicServiceReference<VirtualHost> httpOptions = new AtomicServiceReference("httpOptions");
    private static final AtomicServiceReference<Handler> handlerService = new AtomicServiceReference("handler");
    private boolean enabled;
    private String sslId;
    private String proxy;
    private long asyncResponseTimeout;
    private boolean clientAuth;
    private static WSATConfigService INSTANCE;
    static final long serialVersionUID = 2246736035161242501L;

    public WSATConfigServiceImpl() {
        INSTANCE = this;
    }

    public static WSATConfigService getInstance() {
        return INSTANCE;
    }

    @Reference(name="handler", service=Handler.class)
    protected void setHandlerService(ServiceReference<Handler> ref) {
        handlerService.setReference(ref);
    }

    @Reference(name="httpOptions", service=VirtualHost.class, target="(&(enabled=true)(id=default_host))")
    protected void setHttpOptions(ServiceReference<VirtualHost> ref) {
        httpOptions.setReference(ref);
    }

    protected void unsetHttpOptions(ServiceReference<VirtualHost> ref) {
        httpOptions.unsetReference(ref);
    }

    @Trivial
    public boolean isSSLEnabled() {
        return this.enabled;
    }

    @Trivial
    public long getAsyncResponseTimeout() {
        return this.asyncResponseTimeout;
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) throws SOAPException {
        if (!FrameworkState.isStopping()) {
            this.modified(cc, properties);
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Not activating com.ibm.ws.wsat.service.wsatconfigservice because the framework is stopping", (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        httpOptions.deactivate(cc);
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> properties) throws SOAPException {
        httpOptions.activate(cc);
        handlerService.activate(cc);
        this.enabled = (Boolean)properties.get(SSLEnabled);
        this.sslId = (String)properties.get(SSLRef);
        this.proxy = (String)properties.get(proxyRef);
        if (ASYNC_RESPONSE_TIMEOUT != null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)("asyncResponseTimeout setting overridden to " + ASYNC_RESPONSE_TIMEOUT + " by " + ASYNC_RESPONSE_TIMEOUT_PROPERTY + " system property"), (Object[])new Object[0]);
            }
            this.asyncResponseTimeout = ASYNC_RESPONSE_TIMEOUT;
        } else {
            this.asyncResponseTimeout = (Long)properties.get(asyncResponseTimeoutRef);
        }
        this.clientAuth = (Boolean)properties.get(clientAuthRef);
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"SSLEnabled = [{0}], SSLRefId = [{1}], proxy = [{2}], clientAuth = [{3}], asyncResponseTimeout = [{4}]", (Object[])new Object[]{this.enabled, this.sslId, this.proxy, this.clientAuth, this.asyncResponseTimeout});
        }
        String host = this.getWSATUrl();
        if (this.enabled) {
            Tr.info((TraceComponent)TC, (String)"WSAT_SECURITY_CWLIB0206", (Object[])new Object[]{this.sslId});
            if (host.startsWith("http://")) {
                do {
                    if (TC.isDebugEnabled()) {
                        Tr.debug((TraceComponent)TC, (String)"SSL is enabled but the WSAT URL we got is {0}", (Object[])new Object[]{host});
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsat.service.impl.WSATConfigServiceImpl", (String)"178", (Object)this, (Object[])new Object[]{cc, properties});
                    }
                } while ((host = this.getWSATUrl()).startsWith("http://"));
                if (TC.isDebugEnabled()) {
                    Tr.debug((TraceComponent)TC, (String)"SSL is enabled and the WSAT URL we now have is {0}", (Object[])new Object[]{host});
                }
            }
        }
        if (this.proxy != null && !this.proxy.equals("")) {
            Tr.info((TraceComponent)TC, (String)"WSAT_PROXY_CWLIB0207", (Object[])new Object[]{this.proxy});
            if (this.enabled) {
                if (!this.proxy.startsWith("https://")) {
                    Tr.error((TraceComponent)TC, (String)"WSAT_PROXY_CWLIB0211", (Object[])new Object[]{this.proxy});
                }
            } else if (!this.proxy.startsWith("http://") && !this.proxy.startsWith("https://")) {
                Tr.error((TraceComponent)TC, (String)"WSAT_PROXY_CWLIB0210", (Object[])new Object[]{this.proxy});
            }
        }
        this.setEndpoints((Handler)handlerService.getService(), host);
    }

    public void setEndpoints(Handler handler, String host) {
        String regHost = host + "/" + "RegistrationService";
        String coorHost = host + "/" + "CoordinatorService";
        String partHost = host + "/" + "ParticipantService";
        EndpointReferenceType localCoorEpr = WSATUtil.createEpr(coorHost);
        EndpointReferenceType localRegEpr = WSATUtil.createEpr(regHost);
        EndpointReferenceType localPartEpr = WSATUtil.createEpr(partHost);
        handler.setCoordinatorEndpoint(localCoorEpr);
        handler.setRegistrationEndpoint(localRegEpr);
        handler.setParticipantEndpoint(localPartEpr);
    }

    @Trivial
    public String getSSLReferenceId() {
        return this.sslId;
    }

    @Trivial
    public String getWSATUrl() {
        if (this.proxy != null && this.proxy.length() > 0) {
            return this.proxy + WSATContextRoot;
        }
        return ((VirtualHost)httpOptions.getService()).getUrlString(WSATContextRoot, this.enabled);
    }

    @Trivial
    public boolean isClientAuthEnabled() {
        return this.clientAuth;
    }
}

