/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import javax.annotation.Nullable;

public final class HttpSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private final HttpCommonAttributesGetter<REQUEST, ?> getter;

    public static <REQUEST> SpanNameExtractor<REQUEST> create(HttpCommonAttributesGetter<REQUEST, ?> getter) {
        return new HttpSpanNameExtractor<REQUEST>(getter);
    }

    private HttpSpanNameExtractor(HttpCommonAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public String extract(REQUEST request) {
        String method = this.getter.getHttpRequestMethod(request);
        String route = this.extractRoute(request);
        if (method != null) {
            return route == null ? method : method + " " + route;
        }
        return "HTTP";
    }

    @Nullable
    private String extractRoute(REQUEST request) {
        if (this.getter instanceof HttpServerAttributesGetter) {
            return ((HttpServerAttributesGetter)this.getter).getHttpRoute(request);
        }
        return null;
    }
}

