/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient.impl;

import java.security.Key;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.ObjectSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.httpclient.HttpClientSecurityConfiguration;
import org.opensaml.security.httpclient.HttpClientSecurityConfigurationCriterion;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecurityParametersResolver;
import org.opensaml.security.httpclient.TLSCriteriaSetCriterion;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHttpClientSecurityParametersResolver
implements HttpClientSecurityParametersResolver {
    private Logger log = LoggerFactory.getLogger(BasicHttpClientSecurityParametersResolver.class);

    public Iterable<HttpClientSecurityParameters> resolve(@Nonnull CriteriaSet criteria) throws ResolverException {
        HttpClientSecurityParameters params = this.resolveSingle(criteria);
        if (params != null) {
            return Collections.singletonList(params);
        }
        return Collections.emptyList();
    }

    public HttpClientSecurityParameters resolveSingle(@Nonnull CriteriaSet criteria) throws ResolverException {
        Constraint.isNotNull((Object)criteria, (String)"CriteriaSet was null");
        Constraint.isNotNull((Object)criteria.get(HttpClientSecurityConfigurationCriterion.class), (String)"Resolver requires an instance of HttpClientSecurityConfigurationCriterion");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        this.resolveAndPopulateParams(params, criteria);
        if (this.validate(params)) {
            this.logResult(params);
            return params;
        }
        return null;
    }

    protected void resolveAndPopulateParams(@Nonnull HttpClientSecurityParameters params, @Nonnull CriteriaSet criteria) {
        List<HttpClientSecurityConfiguration> configs = ((HttpClientSecurityConfigurationCriterion)criteria.get(HttpClientSecurityConfigurationCriterion.class)).getConfigurations();
        for (HttpClientSecurityConfiguration config : configs) {
            params.setClientTLSCredential((X509Credential)ObjectSupport.firstNonNull((Object[])new X509Credential[]{params.getClientTLSCredential(), config.getClientTLSCredential()}));
            params.setCredentialsProvider((CredentialsProvider)ObjectSupport.firstNonNull((Object[])new CredentialsProvider[]{params.getCredentialsProvider(), config.getCredentialsProvider()}));
            params.setHostnameVerifier((X509HostnameVerifier)ObjectSupport.firstNonNull((Object[])new X509HostnameVerifier[]{params.getHostnameVerifier(), config.getHostnameVerifier()}));
            params.setTLSCipherSuites((Collection)ObjectSupport.firstNonNull((Object[])new List[]{params.getTLSCipherSuites(), config.getTLSCipherSuites()}));
            params.setTLSProtocols((Collection)ObjectSupport.firstNonNull((Object[])new List[]{params.getTLSProtocols(), config.getTLSProtocols()}));
            params.setTLSTrustEngine((TrustEngine)ObjectSupport.firstNonNull((Object[])new TrustEngine[]{params.getTLSTrustEngine(), config.getTLSTrustEngine()}));
            params.setServerTLSFailureFatal((Boolean)ObjectSupport.firstNonNull((Object[])new Boolean[]{params.isServerTLSFailureFatal(), config.isServerTLSFailureFatal()}));
        }
        if (criteria.contains(TLSCriteriaSetCriterion.class)) {
            params.setTLSCriteriaSet(((TLSCriteriaSetCriterion)criteria.get(TLSCriteriaSetCriterion.class)).getCriteria());
        }
    }

    protected boolean validate(@Nonnull HttpClientSecurityParameters params) {
        return true;
    }

    protected void logResult(@Nonnull HttpClientSecurityParameters params) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolved HttpClientSecurityParameters:");
            Key clientTLSKey = CredentialSupport.extractSigningKey(params.getClientTLSCredential());
            if (clientTLSKey != null) {
                this.log.debug("\tClient TLS credential with key algorithm: {}", (Object)clientTLSKey.getAlgorithm());
            } else {
                this.log.debug("\tClient TLS credential: null");
            }
            this.log.debug("\tHostnameVerifier: {}", (Object)(params.getHostnameVerifier() != null ? "present" : "null"));
            this.log.debug("\tTLS TrustEngine: {}", (Object)(params.getTLSTrustEngine() != null ? "present" : "null"));
            this.log.debug("\tTLS CriteriaSet: {}", (Object)(params.getTLSCriteriaSet() != null ? "present" : "null"));
            this.log.debug("\tServer TLS Failure Fatal: {}", (Object)params.isServerTLSFailureFatal());
            this.log.debug("\tTLS cipher suites: {}", params.getTLSCipherSuites());
            this.log.debug("\tTLS protocols: {}", params.getTLSProtocols());
            this.log.debug("\tAuthCache: {}", (Object)(params.getAuthCache() != null ? "present" : "null"));
            this.log.debug("\tCredentialsProvider: {}", (Object)(params.getCredentialsProvider() != null ? "present" : "null"));
        }
    }
}

