/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.SAMLMessageSecuritySupport;
import org.opensaml.saml.saml2.binding.encoding.impl.BaseSAML2MessageEncoder;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRedirectDeflateEncoder
extends BaseSAML2MessageEncoder {
    private static final Set<String> DISALLOWED_ENDPOINT_QUERY_PARAMS = Sets.newHashSet((Object[])new String[]{"SAMLEncoding", "SAMLRequest", "SAMLResponse", "RelayState", "SigAlg", "Signature"});
    private final Logger log = LoggerFactory.getLogger(HTTPRedirectDeflateEncoder.class);

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    }

    protected void doEncode() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        String endpointURL = this.getEndpointURL((MessageContext<SAMLObject>)messageContext).toString();
        this.removeSignature(outboundMessage);
        String encodedMessage = this.deflateAndBase64Encode(outboundMessage);
        String redirectURL = this.buildRedirectURL((MessageContext<SAMLObject>)messageContext, endpointURL, encodedMessage);
        HttpServletResponse response = this.getHttpServletResponse();
        HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
        HttpServletSupport.setUTF8Encoding((HttpServletResponse)response);
        try {
            response.sendRedirect(redirectURL);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem sending HTTP redirect", (Exception)e);
        }
    }

    protected void removeSignature(SAMLObject message) {
        SignableSAMLObject signableMessage;
        if (message instanceof SignableSAMLObject && (signableMessage = (SignableSAMLObject)message).isSigned()) {
            this.log.debug("Removing SAML protocol message signature");
            signableMessage.setSignature(null);
        }
    }

    /*
     * Exception decompiling
     */
    protected String deflateAndBase64Encode(SAMLObject message) throws MessageEncodingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String buildRedirectURL(MessageContext<SAMLObject> messageContext, String endpoint, String message) throws MessageEncodingException {
        SignatureSigningParameters signingParameters;
        this.log.debug("Building URL to redirect client to");
        URLBuilder urlBuilder = null;
        try {
            urlBuilder = new URLBuilder(endpoint);
        }
        catch (MalformedURLException e) {
            throw new MessageEncodingException("Endpoint URL " + endpoint + " is not a valid URL", (Exception)e);
        }
        List queryParams = urlBuilder.getQueryParams();
        this.removeDisallowedQueryParams(queryParams);
        ArrayList originalParams = new ArrayList(queryParams);
        queryParams.clear();
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        if (outboundMessage instanceof RequestAbstractType) {
            queryParams.add(new Pair((Object)"SAMLRequest", (Object)message));
        } else if (outboundMessage instanceof StatusResponseType) {
            queryParams.add(new Pair((Object)"SAMLResponse", (Object)message));
        } else {
            throw new MessageEncodingException("SAML message is neither a SAML RequestAbstractType or StatusResponseType");
        }
        String relayState = SAMLBindingSupport.getRelayState(messageContext);
        if (SAMLBindingSupport.checkRelayState(relayState)) {
            queryParams.add(new Pair((Object)"RelayState", (Object)relayState));
        }
        if ((signingParameters = SAMLMessageSecuritySupport.getContextSigningParameters(messageContext)) != null && signingParameters.getSigningCredential() != null) {
            String sigAlgURI = this.getSignatureAlgorithmURI(signingParameters);
            Pair sigAlg = new Pair((Object)"SigAlg", (Object)sigAlgURI);
            queryParams.add(sigAlg);
            String sigMaterial = urlBuilder.buildQueryString();
            queryParams.add(new Pair((Object)"Signature", (Object)this.generateSignature(signingParameters.getSigningCredential(), sigAlgURI, sigMaterial)));
            if (!originalParams.isEmpty()) {
                for (Pair param : Lists.reverse(originalParams)) {
                    queryParams.add(0, param);
                }
            }
        } else {
            this.log.debug("No signing credential was supplied, skipping HTTP-Redirect DEFLATE signing");
            queryParams.addAll(originalParams);
        }
        return urlBuilder.buildURL();
    }

    protected void removeDisallowedQueryParams(@Nonnull List<Pair<String, String>> queryParams) {
        Iterator<Pair<String, String>> iter = queryParams.iterator();
        while (iter.hasNext()) {
            String paramName = StringSupport.trimOrNull((String)((String)iter.next().getFirst()));
            if (!DISALLOWED_ENDPOINT_QUERY_PARAMS.contains(paramName)) continue;
            this.log.debug("Removing disallowed query param '{}' from endpoint URL", (Object)paramName);
            iter.remove();
        }
    }

    protected String getSignatureAlgorithmURI(SignatureSigningParameters signingParameters) throws MessageEncodingException {
        if (signingParameters.getSignatureAlgorithm() != null) {
            return signingParameters.getSignatureAlgorithm();
        }
        throw new MessageEncodingException("The signing algorithm URI could not be determined");
    }

    protected String generateSignature(Credential signingCredential, String algorithmURI, String queryString) throws MessageEncodingException {
        this.log.debug(String.format("Generating signature with key type '%s', algorithm URI '%s' over query string '%s'", CredentialSupport.extractSigningKey(signingCredential).getAlgorithm(), algorithmURI, queryString));
        String b64Signature = null;
        try {
            byte[] rawSignature = XMLSigningUtil.signWithURI(signingCredential, algorithmURI, queryString.getBytes("UTF-8"));
            b64Signature = Base64Support.encode((byte[])rawSignature, (boolean)false);
            this.log.debug("Generated digital signature value (base64-encoded) {}", (Object)b64Signature);
        }
        catch (SecurityException e) {
            this.log.error("Error during URL signing process", (Throwable)e);
            throw new MessageEncodingException("Unable to sign URL query string", (Exception)e);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return b64Signature;
    }

    private class NoWrapAutoEndDeflaterOutputStream
    extends DeflaterOutputStream {
        public NoWrapAutoEndDeflaterOutputStream(OutputStream os, int level) {
            super(os, new Deflater(level, true));
        }

        @Override
        public void close() throws IOException {
            if (this.def != null) {
                this.def.end();
            }
            super.close();
        }
    }
}

