/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import jakarta.enterprise.inject.spi.Bean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.util.DescriptorUtils;
import org.jboss.weld.bean.proxy.BytecodeMethodResolver;
import org.jboss.weld.bean.proxy.DecoratorProxy;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.attributes.WeldInjectionPointAttributes;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.security.GetDeclaredMethodAction;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.MethodInformation;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;
import org.jboss.weld.util.bytecode.StaticMethodInformation;

public class DecoratorProxyFactory<T>
extends ProxyFactory<T> {
    public static final String PROXY_SUFFIX = "DecoratorProxy";
    private static final String INIT_MH_METHOD_NAME = "_initMH";
    private final WeldInjectionPointAttributes<?, ?> delegateInjectionPoint;
    private final Field delegateField;
    private final TargetInstanceBytecodeMethodResolver targetInstanceBytecodeMethodResolver = new TargetInstanceBytecodeMethodResolver();

    public DecoratorProxyFactory(String contextId, Class<T> proxyType, WeldInjectionPointAttributes<?, ?> delegateInjectionPoint, Bean<?> bean) {
        super(contextId, proxyType, Collections.emptySet(), bean);
        this.delegateInjectionPoint = delegateInjectionPoint;
        this.delegateField = delegateInjectionPoint instanceof FieldInjectionPoint ? (Field)((FieldInjectionPoint)delegateInjectionPoint).getMember() : null;
    }

    private void addHandlerInitializerMethod(ClassFile proxyClassType, ClassMethod staticConstructor) throws Exception {
        ClassMethod classMethod = proxyClassType.addMethod(2, INIT_MH_METHOD_NAME, "V", new String[]{"Ljava/lang/Object;"});
        CodeAttribute b = classMethod.getCodeAttribute();
        b.aload(0);
        StaticMethodInformation methodInfo = new StaticMethodInformation(INIT_MH_METHOD_NAME, new Class[]{Object.class}, Void.TYPE, classMethod.getClassFile().getName());
        this.invokeMethodHandler(classMethod, methodInfo, false, DEFAULT_METHOD_RESOLVER, staticConstructor);
        b.checkcast(MethodHandler.class);
        b.putfield(classMethod.getClassFile().getName(), "methodHandler", DescriptorUtils.makeDescriptor(MethodHandler.class));
        b.returnInstruction();
        BeanLogger.LOG.createdMethodHandlerInitializerForDecoratorProxy(this.getBeanType());
    }

    @Override
    protected void addAdditionalInterfaces(Set<Class<?>> interfaces) {
        interfaces.add(DecoratorProxy.class);
    }

    @Override
    protected void addMethodsFromClass(ClassFile proxyClassType, ClassMethod staticConstructor) {
        ParameterInjectionPoint parameterIP;
        Method initializerMethod = null;
        int delegateParameterPosition = -1;
        if (this.delegateInjectionPoint instanceof ParameterInjectionPoint && (parameterIP = (ParameterInjectionPoint)this.delegateInjectionPoint).getMember() instanceof Method) {
            initializerMethod = (Method)parameterIP.getMember();
            delegateParameterPosition = parameterIP.getAnnotated().getPosition();
        }
        try {
            if (delegateParameterPosition >= 0) {
                this.addHandlerInitializerMethod(proxyClassType, staticConstructor);
            }
            Class<?> cls = this.getBeanType();
            LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
            this.decoratorMethods(cls, methods);
            for (Method method : methods) {
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                if (method.getDeclaringClass().getName().equals("java.lang.Object") && !method.getName().equals("toString")) continue;
                if (delegateParameterPosition >= 0 && initializerMethod.equals(method)) {
                    this.createDelegateInitializerCode(proxyClassType.addMethod(method), methodInfo, delegateParameterPosition);
                }
                if (!Modifier.isAbstract(method.getModifiers())) continue;
                this.createAbstractMethodCode(proxyClassType.addMethod(method), methodInfo, staticConstructor);
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private void decoratorMethods(Class<?> cls, Set<Method> all) {
        if (cls == null) {
            return;
        }
        all.addAll(Arrays.asList(AccessController.doPrivileged(new GetDeclaredMethodsAction(cls))));
        this.decoratorMethods(cls.getSuperclass(), all);
        for (Class<?> ifc : cls.getInterfaces()) {
            Method[] methods;
            for (Method m : methods = ifc.getMethods()) {
                boolean isEqual = false;
                for (Method a : all) {
                    if (!DecoratorProxyFactory.isEqual(m, a)) continue;
                    isEqual = true;
                    break;
                }
                if (isEqual) continue;
                all.add(m);
            }
        }
    }

    private static boolean isEqual(Method m, Method a) {
        if (m.getName().equals(a.getName()) && m.getParameterTypes().length == a.getParameterTypes().length && m.getReturnType().isAssignableFrom(a.getReturnType())) {
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                if (m.getParameterTypes()[i].isAssignableFrom(a.getParameterTypes()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    @Override
    protected boolean isUsingProxyInstantiator() {
        return false;
    }

    private void createAbstractMethodCode(ClassMethod classMethod, MethodInformation method, ClassMethod staticConstructor) {
        if (this.delegateField != null && !Modifier.isPrivate(this.delegateField.getModifiers())) {
            CodeAttribute b = classMethod.getCodeAttribute();
            b.aload(0);
            b.getfield(classMethod.getClassFile().getName(), this.delegateField.getName(), DescriptorUtils.makeDescriptor(this.delegateField.getType()));
            b.loadMethodParameters();
            b.invokeinterface(this.delegateField.getType().getName(), method.getName(), method.getDescriptor());
            b.returnInstruction();
        } else if (!Modifier.isPrivate(method.getMethod().getModifiers())) {
            this.invokeMethodHandler(classMethod, method, true, this.targetInstanceBytecodeMethodResolver, staticConstructor);
        } else {
            this.createInterceptorBody(classMethod, method, staticConstructor);
        }
    }

    private void createDelegateInitializerCode(ClassMethod classMethod, MethodInformation initializerMethodInfo, int delegateParameterPosition) {
        CodeAttribute b = classMethod.getCodeAttribute();
        b.aload(0);
        int localVariables = 1;
        int actualDelegateParameterPosition = 0;
        for (int i = 0; i < initializerMethodInfo.getMethod().getParameterTypes().length; ++i) {
            if (i == delegateParameterPosition) {
                actualDelegateParameterPosition = localVariables;
            }
            Class<?> type = initializerMethodInfo.getMethod().getParameterTypes()[i];
            BytecodeUtils.addLoadInstruction(b, DescriptorUtils.makeDescriptor(type), localVariables);
            if (type == Long.TYPE || type == Double.TYPE) {
                localVariables += 2;
                continue;
            }
            ++localVariables;
        }
        b.invokespecial(classMethod.getClassFile().getSuperclass(), initializerMethodInfo.getName(), initializerMethodInfo.getDescriptor());
        b.aload(0);
        b.aload(actualDelegateParameterPosition);
        b.invokevirtual(classMethod.getClassFile().getName(), INIT_MH_METHOD_NAME, "(Ljava/lang/Object;)V");
        b.returnInstruction();
    }

    protected class TargetInstanceBytecodeMethodResolver
    implements BytecodeMethodResolver {
        private static final String JAVA_LANG_CLASS_CLASS_NAME = "java.lang.Class";

        protected TargetInstanceBytecodeMethodResolver() {
        }

        @Override
        public void getDeclaredMethod(ClassMethod classMethod, String declaringClass, String methodName, String[] parameterTypes, ClassMethod staticConstructor) {
            StaticMethodInformation methodInfo = new StaticMethodInformation("weld_getTargetClass", new String[0], "Ljava/lang/Class;", TargetInstanceProxy.class.getName());
            DecoratorProxyFactory.this.invokeMethodHandler(classMethod, methodInfo, false, ProxyFactory.DEFAULT_METHOD_RESOLVER, staticConstructor);
            CodeAttribute code = classMethod.getCodeAttribute();
            code.checkcast("java/lang/Class");
            code.ldc(methodName);
            code.iconst(parameterTypes.length);
            code.anewarray(JAVA_LANG_CLASS_CLASS_NAME);
            for (int i = 0; i < parameterTypes.length; ++i) {
                code.dup();
                code.iconst(i);
                String type = parameterTypes[i];
                BytecodeUtils.pushClassType(code, type);
                code.aastore();
            }
            code.invokestatic(GetDeclaredMethodAction.class.getName(), "wrapException", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/security/PrivilegedAction;");
            code.invokestatic(AccessController.class.getName(), "doPrivileged", "(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
            code.checkcast(Method.class);
        }
    }
}

