/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.server;

import com.google.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.OpenIDException;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.association.AssociationSessionType;
import org.openid4java.association.DiffieHellmanSession;
import org.openid4java.discovery.yadis.YadisResolver;
import org.openid4java.message.AssociationError;
import org.openid4java.message.AssociationRequest;
import org.openid4java.message.AssociationResponse;
import org.openid4java.message.AuthFailure;
import org.openid4java.message.AuthImmediateFailure;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.DirectError;
import org.openid4java.message.IndirectError;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;
import org.openid4java.message.VerifyRequest;
import org.openid4java.message.VerifyResponse;
import org.openid4java.server.InMemoryServerAssociationStore;
import org.openid4java.server.IncrementalNonceGenerator;
import org.openid4java.server.NonceGenerator;
import org.openid4java.server.RealmVerifier;
import org.openid4java.server.RealmVerifierFactory;
import org.openid4java.server.ServerAssociationStore;
import org.openid4java.server.ServerException;
import org.openid4java.util.HttpFetcherFactory;

public class ServerManager {
    private static Log _log = LogFactory.getLog(ServerManager.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private ServerAssociationStore _sharedAssociations = new InMemoryServerAssociationStore();
    private ServerAssociationStore _privateAssociations = new InMemoryServerAssociationStore();
    private NonceGenerator _nonceGenerator = new IncrementalNonceGenerator();
    private AssociationSessionType _minAssocSessEnc = AssociationSessionType.NO_ENCRYPTION_SHA1MAC;
    private AssociationSessionType _prefAssocSessEnc = AssociationSessionType.DH_SHA256;
    private int _expireIn = 1800;
    private String _userSetupUrl = null;
    private String _signFields;
    private String[] _signExtensions;
    private RealmVerifier _realmVerifier;
    private String _opEndpointUrl;

    public ServerAssociationStore getSharedAssociations() {
        return this._sharedAssociations;
    }

    public void setSharedAssociations(ServerAssociationStore sharedAssociations) {
        this._sharedAssociations = sharedAssociations;
    }

    public ServerAssociationStore getPrivateAssociations() {
        return this._privateAssociations;
    }

    public void setPrivateAssociations(ServerAssociationStore privateAssociations) {
        this._privateAssociations = privateAssociations;
    }

    public AssociationSessionType getMinAssocSessEnc() {
        return this._minAssocSessEnc;
    }

    public NonceGenerator getNonceGenerator() {
        return this._nonceGenerator;
    }

    public void setNonceGenerator(NonceGenerator nonceGenerator) {
        this._nonceGenerator = nonceGenerator;
    }

    public void setMinAssocSessEnc(AssociationSessionType minAssocSessEnc) {
        this._minAssocSessEnc = minAssocSessEnc;
    }

    public AssociationSessionType getPrefAssocSessEnc() {
        return this._prefAssocSessEnc;
    }

    public void setPrefAssocSessEnc(AssociationSessionType type) throws ServerException {
        if (!Association.isHmacSupported(type.getAssociationType()) || !DiffieHellmanSession.isDhSupported(type)) {
            throw new ServerException("Unsupported association / session type: " + type.getSessionType() + " : " + type.getAssociationType());
        }
        if (this._minAssocSessEnc.isBetter(type)) {
            throw new ServerException("Minimum encryption settings cannot be better than the preferred");
        }
        this._prefAssocSessEnc = type;
    }

    public int getExpireIn() {
        return this._expireIn;
    }

    public void setExpireIn(int _expireIn) {
        this._expireIn = _expireIn;
    }

    public String getUserSetupUrl() {
        return this._userSetupUrl;
    }

    public void setUserSetupUrl(String userSetupUrl) {
        this._userSetupUrl = userSetupUrl;
    }

    public void setSignFields(String signFields) {
        this._signFields = signFields;
    }

    public String getSignFields() {
        return this._signFields;
    }

    public void setSignExtensions(String[] extensins) {
        this._signExtensions = extensins;
    }

    public String[] getSignExtensions() {
        return this._signExtensions;
    }

    public RealmVerifier getRealmVerifier() {
        return this._realmVerifier;
    }

    public void setRealmVerifier(RealmVerifier realmVerifier) {
        this._realmVerifier = realmVerifier;
    }

    public boolean getEnforceRpId() {
        return this._realmVerifier.getEnforceRpId();
    }

    public void setEnforceRpId(boolean enforceRpId) {
        this._realmVerifier.setEnforceRpId(enforceRpId);
    }

    public String getOPEndpointUrl() {
        return this._opEndpointUrl;
    }

    public void setOPEndpointUrl(String opEndpointUrl) {
        this._opEndpointUrl = opEndpointUrl;
    }

    public ServerManager() {
        this(new RealmVerifierFactory(new YadisResolver(new HttpFetcherFactory())));
    }

    @Inject
    public ServerManager(RealmVerifierFactory factory) {
        this._realmVerifier = factory.getRealmVerifierForServer();
        this._realmVerifier.setEnforceRpId(false);
    }

    public Message associationResponse(ParameterList requestParams) {
        boolean isVersion2 = requestParams.hasParameter("openid.ns");
        _log.info((Object)"Processing association request...");
        try {
            AssociationRequest assocReq = AssociationRequest.createAssociationRequest(requestParams);
            isVersion2 = assocReq.isVersion2();
            AssociationSessionType type = assocReq.getType();
            if (!Association.isHmacSupported(type.getAssociationType()) || !DiffieHellmanSession.isDhSupported(type) || this._minAssocSessEnc.isBetter(type)) {
                throw new AssociationException("Unable create association for: " + type.getSessionType() + " / " + type.getAssociationType());
            }
            Association assoc = this._sharedAssociations.generate(type.getAssociationType(), this._expireIn);
            _log.info((Object)("Returning shared association; handle: " + assoc.getHandle()));
            return AssociationResponse.createAssociationResponse(assocReq, assoc);
        }
        catch (OpenIDException e) {
            if (isVersion2) {
                _log.warn((Object)"Cannot establish association, responding with an OpenID2 association error.", (Throwable)e);
                return AssociationError.createAssociationError(e.getMessage(), this._prefAssocSessEnc);
            }
            _log.warn((Object)("Error processing an OpenID1 association request: " + e.getMessage() + " Responding with a dummy association."), (Throwable)e);
            try {
                Association dummyAssoc = this._sharedAssociations.generate("HMAC-SHA1", 0);
                AssociationRequest dummyRequest = AssociationRequest.createAssociationRequest(AssociationSessionType.NO_ENCRYPTION_COMPAT_SHA1MAC);
                return AssociationResponse.createAssociationResponse(dummyRequest, dummyAssoc);
            }
            catch (OpenIDException ee) {
                _log.error((Object)"Error creating negative OpenID1 association response.", (Throwable)e);
                return null;
            }
        }
    }

    public Message authResponse(ParameterList requestParams, String userSelId, String userSelClaimed, boolean authenticatedAndApproved) {
        return this.authResponse(requestParams, userSelId, userSelClaimed, authenticatedAndApproved, this._opEndpointUrl, true);
    }

    public Message authResponse(AuthRequest authReq, String userSelId, String userSelClaimed, boolean authenticatedAndApproved) {
        return this.authResponse(authReq, userSelId, userSelClaimed, authenticatedAndApproved, this._opEndpointUrl, true);
    }

    public Message authResponse(ParameterList requestParams, String userSelId, String userSelClaimed, boolean authenticatedAndApproved, boolean signNow) {
        return this.authResponse(requestParams, userSelId, userSelClaimed, authenticatedAndApproved, this._opEndpointUrl, signNow);
    }

    public Message authResponse(AuthRequest authReq, String userSelId, String userSelClaimed, boolean authenticatedAndApproved, boolean signNow) {
        return this.authResponse(authReq, userSelId, userSelClaimed, authenticatedAndApproved, this._opEndpointUrl, signNow);
    }

    public Message authResponse(ParameterList requestParams, String userSelId, String userSelClaimed, boolean authenticatedAndApproved, String opEndpoint) {
        return this.authResponse(requestParams, userSelId, userSelClaimed, authenticatedAndApproved, opEndpoint, true);
    }

    public Message authResponse(AuthRequest auhtReq, String userSelId, String userSelClaimed, boolean authenticatedAndApproved, String opEndpoint) {
        return this.authResponse(auhtReq, userSelId, userSelClaimed, authenticatedAndApproved, opEndpoint, true);
    }

    public Message authResponse(ParameterList requestParams, String userSelId, String userSelClaimed, boolean authenticatedAndApproved, String opEndpoint, boolean signNow) {
        _log.info((Object)"Parsing authentication request...");
        boolean isVersion2 = "http://specs.openid.net/auth/2.0".equals(requestParams.getParameterValue("openid.ns"));
        try {
            AuthRequest authReq = AuthRequest.createAuthRequest(requestParams, this._realmVerifier);
            return this.authResponse(authReq, userSelId, userSelClaimed, authenticatedAndApproved, opEndpoint, signNow);
        }
        catch (MessageException e) {
            if (requestParams.hasParameter("openid.return_to")) {
                _log.error((Object)"Invalid authentication request; responding with an indirect error message.", (Throwable)e);
                return IndirectError.createIndirectError(e, requestParams.getParameterValue("openid.return_to"), !isVersion2);
            }
            _log.error((Object)"Invalid authentication request; responding with a direct error message.", (Throwable)e);
            return DirectError.createDirectError(e, !isVersion2);
        }
    }

    public Message authResponse(AuthRequest authReq, String userSelId, String userSelClaimed, boolean authenticatedAndApproved, String opEndpoint, boolean signNow) {
        _log.info((Object)"Processing authentication request...");
        boolean isVersion2 = authReq.isVersion2();
        try {
            new URL(opEndpoint);
        }
        catch (MalformedURLException e) {
            String errMsg = "Invalid OP-endpoint configured; cannot issue authentication responses." + opEndpoint;
            _log.error((Object)errMsg, (Throwable)e);
            return DirectError.createDirectError(new ServerException(errMsg, (Throwable)e), isVersion2);
        }
        try {
            String claimed;
            String id;
            if (authReq.getReturnTo() == null) {
                _log.error((Object)"No return_to in the received (valid) auth request; returning null auth response.");
                return null;
            }
            if ("http://specs.openid.net/auth/2.0/identifier_select".equals(authReq.getIdentity())) {
                id = userSelId;
                claimed = userSelClaimed;
            } else {
                id = userSelId != null ? userSelId : authReq.getIdentity();
                String string = claimed = userSelClaimed != null ? userSelClaimed : authReq.getClaimed();
            }
            if (id == null) {
                throw new ServerException("No identifier provided by the authntication requestor by the OpenID Provider");
            }
            if (DEBUG) {
                _log.debug((Object)("Using ClaimedID: " + claimed + " OP-specific ID: " + id));
            }
            if (authenticatedAndApproved) {
                Association assoc = null;
                String handle = authReq.getHandle();
                String invalidateHandle = null;
                if (handle != null) {
                    assoc = this._sharedAssociations.load(handle);
                    if (assoc == null) {
                        _log.info((Object)("Invalidating handle: " + handle));
                        invalidateHandle = handle;
                    } else {
                        _log.info((Object)("Loaded shared association; handle: " + handle));
                    }
                }
                if (assoc == null) {
                    assoc = this._privateAssociations.generate(this._prefAssocSessEnc.getAssociationType(), this._expireIn);
                    _log.info((Object)("Generated private association; handle: " + assoc.getHandle()));
                }
                AuthSuccess response = AuthSuccess.createAuthSuccess(opEndpoint, claimed, id, !isVersion2, authReq.getReturnTo(), isVersion2 ? this._nonceGenerator.next() : null, invalidateHandle, assoc, false);
                if (this._signFields != null) {
                    response.setSignFields(this._signFields);
                }
                if (this._signExtensions != null) {
                    response.setSignExtensions(this._signExtensions);
                }
                if (signNow) {
                    response.setSignature(assoc.sign(response.getSignedText()));
                }
                _log.info((Object)("Returning positive assertion for " + response.getReturnTo()));
                return response;
            }
            if (authReq.isImmediate()) {
                _log.error((Object)("Responding with immediate authentication failure to " + authReq.getReturnTo()));
                authReq.setImmediate(false);
                String userSetupUrl = this._userSetupUrl == null ? null : this._userSetupUrl + (this._userSetupUrl.contains("?") ? "&" : "?") + authReq.wwwFormEncoding();
                return AuthImmediateFailure.createAuthImmediateFailure(userSetupUrl, authReq.getReturnTo(), !isVersion2);
            }
            _log.error((Object)("Responding with authentication failure to " + authReq.getReturnTo()));
            return new AuthFailure(!isVersion2, authReq.getReturnTo());
        }
        catch (OpenIDException e) {
            if (authReq.hasParameter("openid.return_to")) {
                _log.error((Object)"Error processing authentication request; responding with an indirect error message.", (Throwable)e);
                return IndirectError.createIndirectError(e, authReq.getReturnTo(), !isVersion2);
            }
            _log.error((Object)"Error processing authentication request; responding with a direct error message.", (Throwable)e);
            return DirectError.createDirectError(e, !isVersion2);
        }
    }

    public void sign(AuthSuccess authSuccess) throws ServerException, AssociationException {
        String handle = authSuccess.getHandle();
        Association assoc = this._sharedAssociations.load(handle);
        if (assoc == null) {
            assoc = this._privateAssociations.load(handle);
        }
        if (assoc == null) {
            throw new ServerException("No association found for handle: " + handle);
        }
        authSuccess.setSignature(assoc.sign(authSuccess.getSignedText()));
    }

    public Message verify(ParameterList requestParams) {
        _log.info((Object)"Processing verification request...");
        boolean isVersion2 = true;
        try {
            VerifyRequest vrfyReq = VerifyRequest.createVerifyRequest(requestParams);
            isVersion2 = vrfyReq.isVersion2();
            String handle = vrfyReq.getHandle();
            boolean verified = false;
            Association assoc = this._privateAssociations.load(handle);
            if (assoc != null) {
                _log.info((Object)("Loaded private association; handle: " + handle));
                verified = assoc.verifySignature(vrfyReq.getSignedText(), vrfyReq.getSignature());
                this._privateAssociations.remove(handle);
            }
            VerifyResponse vrfyResp = VerifyResponse.createVerifyResponse(!vrfyReq.isVersion2());
            vrfyResp.setSignatureVerified(verified);
            if (verified) {
                String invalidateHandle = vrfyReq.getInvalidateHandle();
                if (invalidateHandle != null && this._sharedAssociations.load(invalidateHandle) == null) {
                    _log.info((Object)("Confirming shared association invalidate handle: " + invalidateHandle));
                    vrfyResp.setInvalidateHandle(invalidateHandle);
                }
            } else {
                _log.error((Object)("Signature verification failed, handle: " + handle));
            }
            _log.info((Object)("Responding with " + (verified ? "positive" : "negative") + " verification response"));
            return vrfyResp;
        }
        catch (OpenIDException e) {
            _log.error((Object)"Error processing verification request; responding with verification error.", (Throwable)e);
            return DirectError.createDirectError(e, !isVersion2);
        }
    }
}

