/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.ax;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.AxPayload;

public class StoreRequest
extends AxPayload {
    private static Log _log = LogFactory.getLog(StoreRequest.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    protected StoreRequest() {
        this._parameters.set(new Parameter("mode", "store_request"));
        if (DEBUG) {
            _log.debug((Object)"Created empty store request.");
        }
    }

    public static StoreRequest createStoreRequest() {
        return new StoreRequest();
    }

    protected StoreRequest(ParameterList params) {
        this._parameters = params;
    }

    public static StoreRequest createStoreRequest(ParameterList params) throws MessageException {
        StoreRequest req = new StoreRequest(params);
        if (!req.isValid()) {
            throw new MessageException("Invalid parameters for a store request");
        }
        if (DEBUG) {
            _log.debug((Object)("Created store request from parameter list:\n" + params));
        }
        return req;
    }

    public boolean isValid() {
        if (!this._parameters.hasParameter("mode") || !"store_request".equals(this._parameters.getParameterValue("mode"))) {
            _log.warn((Object)("Invalid mode value in store_request: " + this._parameters.getParameterValue("mode")));
            return false;
        }
        return super.isValid();
    }
}

