/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.offheapstore.disk.storage;

import org.ehcache.shadow.org.terracotta.offheapstore.util.AATreeSet;

class Region
extends AATreeSet.AbstractTreeNode<Region>
implements Comparable<Comparable<?>> {
    private long start;
    private long end;
    private long availableBitSet;

    Region(long value) {
        this(value, value);
    }

    Region(long start, long end) {
        this.start = start;
        this.end = end;
        this.updateAvailable();
    }

    Region(Region r) {
        this(r.start(), r.end());
    }

    long available() {
        if (this.getLeft().getPayload() == null && this.getRight().getPayload() == null) {
            return this.availableHere();
        }
        return this.availableBitSet;
    }

    long availableHere() {
        long bits = 0L;
        for (int i = 0; i < 63; ++i) {
            long size = 1L << i;
            long mask = size - 1L;
            long a = this.start + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.end - a + 1L < size) continue;
            bits |= size;
        }
        return bits;
    }

    private void updateAvailable() {
        Region left = (Region)this.getLeft().getPayload();
        Region right = (Region)this.getRight().getPayload();
        long leftAvailable = left == null ? 0L : left.available();
        long rightAvailable = right == null ? 0L : right.available();
        this.availableBitSet = this.availableHere() | leftAvailable | rightAvailable;
    }

    @Override
    public void setLeft(AATreeSet.Node<Region> l) {
        super.setLeft(l);
        this.updateAvailable();
    }

    @Override
    public void setRight(AATreeSet.Node<Region> r) {
        super.setRight(r);
        this.updateAvailable();
    }

    public String toString() {
        return "Range(" + this.start + "," + this.end + ") available:" + Long.toBinaryString(this.availableHere());
    }

    public long size() {
        return this.isNull() ? 0L : this.end - this.start + 1L;
    }

    protected boolean isNull() {
        return this.start > this.end;
    }

    public Region remove(Region r) {
        if (r.start < this.start || r.end > this.end) {
            throw new AssertionError((Object)("Ranges : Illegal value passed to remove : " + this + " remove called for : " + r));
        }
        if (this.start == r.start) {
            this.start = r.end + 1L;
            this.updateAvailable();
            return null;
        }
        if (this.end == r.end) {
            this.end = r.start - 1L;
            this.updateAvailable();
            return null;
        }
        Region newRegion = new Region(r.end + 1L, this.end);
        this.end = r.start - 1L;
        this.updateAvailable();
        return newRegion;
    }

    public void merge(Region r) {
        if (this.start == r.end + 1L) {
            this.start = r.start;
        } else if (this.end == r.start - 1L) {
            this.end = r.end;
        } else {
            throw new AssertionError((Object)("Ranges : Merge called on non contiguous values : [this]:" + this + " and " + r));
        }
        this.updateAvailable();
    }

    @Override
    public int compareTo(Comparable<?> other) {
        if (other instanceof Region) {
            Region r = (Region)other;
            if (this.start < r.start) {
                return -1;
            }
            if (this.end > r.end) {
                return 1;
            }
            return 0;
        }
        if (other instanceof Long) {
            Long l = (Long)other;
            if (l > this.end) {
                return -1;
            }
            if (l < this.start) {
                return 1;
            }
            return 0;
        }
        throw new AssertionError();
    }

    public boolean equals(Object other) {
        if (other instanceof Region) {
            Region r = (Region)other;
            return this.start == r.start && this.end == r.end;
        }
        throw new AssertionError();
    }

    public int hashCode() {
        return 3 * (int)this.start ^ 7 * (int)(this.start >>> 32) ^ 5 * (int)this.end ^ 11 * (int)(this.end >>> 32);
    }

    @Override
    public Region getPayload() {
        return this;
    }

    @Override
    public void swapPayload(AATreeSet.Node<Region> other) {
        if (!(other instanceof Region)) {
            throw new AssertionError();
        }
        Region r = (Region)other;
        long temp = this.start;
        this.start = r.start;
        r.start = temp;
        temp = this.end;
        this.end = r.end;
        r.end = temp;
        this.updateAvailable();
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }
}

