/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.container.protocol.SipProtocolLayer;
import com.ibm.ws.sip.stack.transaction.transport.SIPConnectionsModel;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnectionFactory;
import com.ibm.ws.sip.stack.transport.sip.netty.SipInboundChannel;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SIPConnectionFactoryImplWs
implements SIPConnectionFactory {
    private static final TraceComponent tc = Tr.register(SIPConnectionFactoryImplWs.class);
    private static SIPConnectionFactoryImplWs s_instance = new SIPConnectionFactoryImplWs();
    private Map<ListeningPoint, SipInboundChannel> m_channels = new HashMap<ListeningPoint, SipInboundChannel>(8);

    public static SIPConnectionFactoryImplWs instance() {
        return s_instance;
    }

    private SIPConnectionFactoryImplWs() {
    }

    @Override
    public SipInboundChannel createListeningConnection(ListeningPoint lp) {
        SipInboundChannel channel = this.m_channels.get(lp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (lp != null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"createListeningConnection", (Object[])new Object[]{"listening point [" + lp.toString() + ']'});
            } else {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"createListeningConnection", (Object[])new Object[]{"no listening point"});
            }
        }
        return channel;
    }

    public SipInboundChannel getListeningConnection(ListeningPoint lp) {
        return this.createListeningConnection(lp);
    }

    void addListeningConnection(ListeningPoint lp, SipInboundChannel channel, String chainName) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"addListeningConnection", (Object[])new Object[]{"adding channel [" + channel + "] to chain [" + chainName + "] on listening point [" + lp + ']'});
        }
        this.m_channels.put(lp, channel);
        SIPConnectionsModel.instance().addedListeningPoint(lp);
        SipProtocolLayer.getInstance().initNewInterfaces(lp);
    }

    public Map<ListeningPoint, SipInboundChannel> getInboundChannels() {
        return this.m_channels;
    }
}

