/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.pmi;

import com.ibm.ws.sip.container.pmi.SessionInterface;
import com.ibm.ws.sip.container.pmi.basic.SessionsCounter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionModule
implements SessionInterface {
    private static final Logger s_logger = Logger.getLogger(SessionModule.class.getName());
    private long _totalSipSessions = 0L;
    private long _totalSipAppSessions = 0L;
    private SessionsCounter _appCounter = null;
    protected String _appName;

    public SessionModule(String appFullName, SessionsCounter appCounter) {
        this._appName = appFullName;
        this._appCounter = appCounter;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void incrementSipSessionCount() {
        this._appCounter.sipSessionIncrement();
        if (s_logger.isLoggable(Level.FINEST)) {
            StringBuffer buf = new StringBuffer();
            buf.append("ADD SipSessions to applicationName <");
            buf.append(this._appName);
            buf.append("> ");
            buf.append(" sipSessionCouner = ");
            buf.append(this._appCounter.getSipSessions());
            s_logger.logp(Level.FINEST, SessionModule.class.getName(), "incrementSipSessionCount", buf.toString());
        }
    }

    @Override
    public void decrementSipSessionCount() {
        this._appCounter.sipSessionDecrement();
        if (s_logger.isLoggable(Level.FINEST)) {
            StringBuffer buf = new StringBuffer();
            buf.append("REMOVE SipSessions  from applicationName <");
            buf.append(this._appName);
            buf.append("> ");
            buf.append(" sipSessionCouner = ");
            buf.append(this._appCounter.getSipSessions());
            s_logger.logp(Level.FINEST, SessionModule.class.getName(), "decrementSipSessionCount", buf.toString());
        }
    }

    @Override
    public void incrementSipAppSessionCount() {
        this._appCounter.sipAppSessionIncrement();
        if (s_logger.isLoggable(Level.FINEST)) {
            StringBuffer buf = new StringBuffer();
            buf.append("ADD Sip Application Sessions to applicationName <");
            buf.append(this._appName);
            buf.append("> ");
            buf.append(" sipSessionCouner = ");
            buf.append(this._appCounter.getSipAppSessions());
            s_logger.logp(Level.FINEST, SessionModule.class.getName(), "incrementSipAppSessionCount", buf.toString());
        }
    }

    @Override
    public void decrementSipAppSessionCount() {
        this._appCounter.sipAppSessionDecrement();
        if (s_logger.isLoggable(Level.FINEST)) {
            StringBuffer buf = new StringBuffer();
            buf.append("REMOVE SipApplicationSession from app = ");
            buf.append(this._appName);
            buf.append(" _sipAppSessions = ");
            buf.append(this._appCounter.getSipAppSessions());
            s_logger.logp(Level.FINEST, SessionModule.class.getName(), "decrementSipAppSessionCount", buf.toString());
        }
    }

    @Override
    public void updateCounters() {
        this._totalSipAppSessions = this._appCounter.getSipAppSessions();
        this._totalSipSessions = this._appCounter.getSipSessions();
    }
}

