/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl.netty;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.channel.resolver.impl.netty.SipResolverTransport;
import com.ibm.ws.sip.channel.resolver.impl.netty.SipResolverTransportListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.openliberty.netty.internal.BootstrapExtended;
import io.openliberty.netty.internal.ChannelInitializerWrapper;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.exception.NettyException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Vector;

class SipResolverUdpTransport
implements SipResolverTransport {
    private static final LogMgr c_logger = Log.get(SipResolverUdpTransport.class);
    private static NettyFramework _framework;
    private static final int WRITE_STATE_DISCONNECTED = 0;
    private static final int WRITE_STATE_CONNECTING = 1;
    private static final int WRITE_STATE_IDLE = 2;
    private static final int WRITE_STATE_WRITE_ACTIVE = 3;
    private static final int WRITE_STATE_SHUTDOWN = 4;
    private static final int READ_STATE_READY = 1;
    private static final int READ_STATE_DISCONNECTED = 2;
    private static final int READ_STATE_SHUTDOWN = 3;
    private static final int MAX_WRITE_QUEUE_SIZE = 5000;
    private SipResolverTransportListener _transportListener = null;
    private Vector<InetSocketAddress> _nameServers = null;
    private Iterator<InetSocketAddress> _nameServerIterator = null;
    private int _writeState = 0;
    private int _readState = 2;
    private boolean _shutdown = false;
    private Queue<ByteBuf> _requestQueue = new LinkedList<ByteBuf>();
    protected Channel channel;
    private BootstrapExtended bootstrap;
    private static boolean _channelInitialized;
    protected InetSocketAddress _currentSocketAddress = null;
    private String CHAINNAME = "SipResolver-udp-outbound";
    private boolean reConnectAllowed = true;
    private int _connectionFailedCount = -1;
    private int _transportErrorCount = 0;
    private boolean connectDone = false;
    private int _ConnectFailuresAllowed = 2;
    private int _TransportErrorsAllowed = 3;
    protected static final int TIMEOUT_TIME = 3000;

    protected SipResolverUdpTransport() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: constructor()");
            c_logger.traceExit(this, "SipResolverUdpTransport: constructor()");
        }
    }

    protected synchronized void initialize(NettyFramework framework) {
        block6: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "SipResolverUdpTransport: initialize() _channelInitialized:" + _channelInitialized);
            }
            if (!_channelInitialized) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: initialize: getChannelFramewor()");
                }
                _framework = framework;
                try {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("ExternalName", this.CHAINNAME);
                    this.bootstrap = _framework.createUDPBootstrapOutbound(options);
                    this._writeState = 0;
                    this._readState = 2;
                    this.reConnectAllowed = true;
                    _channelInitialized = true;
                }
                catch (NettyException e2) {
                    if (!c_logger.isTraceEntryExitEnabled()) break block6;
                    c_logger.traceExit(this, "SipResolverUdpTransport: initialize failed due to: " + (Object)((Object)e2));
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: initialize()");
        }
    }

    protected SipResolverUdpTransport(Vector<InetSocketAddress> nameServers, SipResolverTransportListener transportListener, NettyFramework framework) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: constructor(Vector, SipResolverTransportListener): entry: id=" + this.hashCode() + " " + framework);
        }
        this.initialize(framework);
        this._nameServers = nameServers;
        this._nameServerIterator = this._nameServers.iterator();
        this._transportListener = transportListener;
        this._ConnectFailuresAllowed = this._nameServers.size() * 2;
        this._TransportErrorsAllowed = this._nameServers.size() * 3;
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
        this.bootstrap.handler((ChannelHandler)new SipResolverUDPInitializer(this.bootstrap.getBaseInitializer()));
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport: contructor: _ConnectFailuresAllowed: " + this._ConnectFailuresAllowed);
            c_logger.traceDebug("SipResolverTcpTransport: contructor: _TransportErrorsAllowed: " + this._TransportErrorsAllowed);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: constructor(Vector, SipResolverTransportListener): entry: ");
        }
    }

    protected synchronized void shutdown() {
        block5: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "SipResolverUdpTransport: shutdown: entry: id=" + this.hashCode());
            }
            this._shutdown = true;
            this._requestQueue.clear();
            this._writeState = 4;
            this._readState = 3;
            if (this.channel != null) {
                try {
                    this.channel.close().sync();
                }
                catch (InterruptedException e2) {
                    if (!c_logger.isTraceEntryExitEnabled()) break block5;
                    c_logger.traceExit(this, "SipResolverUdpTransport: shutdown: interrupted waiting for channel close: " + e2);
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: shutdown: exit: ");
        }
    }

    private void talkToDNS() {
        block12: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "SipResolverUdpTransport: talkToDNS: entry: id=" + this.hashCode());
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: talkToDNS: Find DNS Server in list");
            }
            if (!this._nameServerIterator.hasNext()) {
                this._nameServerIterator = this._nameServers.iterator();
                this._currentSocketAddress = this._nameServerIterator.next();
            } else {
                this._currentSocketAddress = this._nameServerIterator.next();
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: talkToDNS: SIP Resolver nameserver target: " + this._currentSocketAddress);
            }
            if (this.connectDone) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: talkToDNS: connectAsynch called go right to ready()");
                }
                this.ready();
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: talkToDNS: connectAsynch not called yet, do so now");
                }
                try {
                    _framework.startOutbound(this.bootstrap, this._currentSocketAddress.getHostString(), this._currentSocketAddress.getPort(), f -> {
                        if (f.isCancelled() || !f.isSuccess()) {
                            if (c_logger.isWarnEnabled()) {
                                c_logger.warn("Resolver channel exception during connect: " + f.cause().getMessage());
                            }
                            this.destroy((Exception)f.cause());
                        } else {
                            this.channel = f.channel();
                            this.ready();
                        }
                    });
                }
                catch (NettyException e2) {
                    e2.printStackTrace();
                    if (!c_logger.isWarnEnabled()) break block12;
                    c_logger.warn("Resolver channel exception during connect: " + e2.getMessage());
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: talkToDNS: exit: ");
        }
    }

    public void ready() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: ready: entry: id=" + this.hashCode());
        }
        this.connectDone = true;
        this._writeState = 2;
        this._readState = 1;
        this._connectionFailedCount = 0;
        this.reConnectAllowed = false;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: ready: UDP read request");
        }
        this.drainRequestQueue();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: ready: exit: ");
        }
    }

    public void destroy(Exception e2) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: destroy(Exception e)");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: destroy: Socket destroyed " + e2);
        }
        this._readState = 2;
        this._writeState = 0;
        ++this._connectionFailedCount;
        if (this._connectionFailedCount <= this._ConnectFailuresAllowed) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: error: calling transportError - _connectionFailedCount: " + this._connectionFailedCount);
            }
            this._transportListener.transportError(e2, this);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: error: calling transportFailed - _connectionFailedCount: " + this._connectionFailedCount);
            }
            this._connectionFailedCount = 0;
            this._transportErrorCount = 0;
            this._transportListener.transportFailed(e2, this);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: destroy(Exception e)");
        }
    }

    @Override
    public synchronized void writeRequest(ByteBuf requestBuffer) throws IOException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: writeRequest: entry id=" + this.hashCode());
        }
        if (this._shutdown) {
            throw new IllegalStateException("SIP UDP Resolver transport is shutdown.");
        }
        switch (this._writeState) {
            case 4: {
                if (!c_logger.isTraceDebugEnabled()) break;
                c_logger.traceDebug("SipResolverUdpTransport:writeRequest: WRITE_STATE_SHUTDOWN");
                break;
            }
            case 2: {
                ChannelFuture writeFuture;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport:writeRequest: WRITE_STATE_IDLE");
                }
                if (!(writeFuture = this.writeBufferAsDatagram(requestBuffer)).isDone()) {
                    this._writeState = 3;
                    writeFuture.addListener(f -> {
                        if (f.isSuccess()) {
                            this.writeComplete();
                        } else {
                            this.writeError((Exception)f.cause());
                        }
                    });
                    break;
                }
                this.writeComplete();
                break;
            }
            case 3: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport:writeRequest: WRITE_STATE_WRITE_ACTIVE");
                }
                if (this._requestQueue.size() > 5000) {
                    throw new IOException("Maximum write queue size is being exceeded");
                }
                this._requestQueue.add(requestBuffer);
                break;
            }
            case 1: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport:writeRequest: WRITE_STATE_CONNECTING");
                }
                this._requestQueue.add(requestBuffer);
                break;
            }
            case 0: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport:writeRequest: WRITE_STATE_DISCONNECTED");
                }
                this._requestQueue.add(requestBuffer);
                if (!this.reConnectAllowed) break;
                this.talkToDNS();
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: writeRequest: exit: ");
        }
    }

    public void destroyFromTimeout(Exception e2) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: destroyFromTimeout(Exception e)");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: destroyFromTimeout: Socket destroyed " + e2);
        }
        this._readState = 2;
        this._writeState = 0;
        ++this._transportErrorCount;
        if (this._transportErrorCount <= this._TransportErrorsAllowed) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: destroyFromTimeout: calling transportError - _transprtErrorCount: " + this._transportErrorCount);
            }
            this._transportListener.transportError(e2, this);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: destroyFromTimeout: calling transportFailed - _transprtErrorCount: " + this._transportErrorCount);
            }
            this._transportErrorCount = 0;
            this._transportListener.transportFailed(e2, this);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: destroyFromTimeout(Exception e)");
        }
    }

    @Override
    public void prepareForReConnect() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: prepareForReConnect");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: prepareForReConnect: clear out _requestQueue: # of items: " + this._requestQueue.size());
        }
        this._requestQueue.clear();
        this.reConnectAllowed = true;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: prepareForReConnect");
        }
    }

    protected void messageRead(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: complete(VirtualConnection vc, UDPReadRequestContext rsc) _readState: " + this._readState);
        }
        this._transportErrorCount = 0;
        this._transportListener.responseReceived(msg);
        if (this._readState != 2) {
            this._readState = 1;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: complete: read message body");
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: complete: UDP read request");
            }
            this.channel.read();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: complete(VirtualConnection vc, UDPReadRequestContext rsc)");
        }
    }

    public void readError(ChannelHandlerContext ctx, Throwable e2) throws Exception {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: readError(Exception e)");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: Read error: " + e2);
        }
        if (!this._shutdown) {
            this._readState = 2;
            this._writeState = 0;
            ++this._transportErrorCount;
            if (this._transportErrorCount < this._TransportErrorsAllowed) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: error: calling transportError - _transprtErrorCount: " + this._transportErrorCount);
                }
                this._transportListener.transportError((Exception)e2, this);
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: error: calling transportFailed - _transprtErrorCount: " + this._transportErrorCount);
                }
                this._transportErrorCount = 0;
                this._transportListener.transportFailed((Exception)e2, this);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: error(VirtualConnection vc, UDPReadRequestContext rrc, IOException ioe)");
        }
    }

    public void writeComplete() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: complete(VirtualConnection vc, UDPWriteRequestContext wrc)");
        }
        this._transportErrorCount = 0;
        this.drainRequestQueue();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: complete(VirtualConnection vc, UDPWriteRequestContext wrc)");
        }
    }

    public void writeError(Exception e2) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: writeError(Exception e)");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: Write error: " + e2);
        }
        if (!this._shutdown) {
            this._readState = 2;
            this._writeState = 0;
            ++this._transportErrorCount;
            if (this._transportErrorCount < this._TransportErrorsAllowed) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: error: calling transportError - _transprtErrorCount: " + this._transportErrorCount);
                }
                this._transportListener.transportError(e2, this);
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: error: calling transportFailed - _transprtErrorCount: " + this._transportErrorCount);
                }
                this._transportErrorCount = 0;
                this._transportListener.transportFailed(e2, this);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: error(VirtualConnection vc, UDPWriteRequestContext wrc, IOException ioe)");
        }
    }

    private synchronized void drainRequestQueue() {
        block5: {
            ByteBuf requestBuffer;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "SipResolverUdpTransport: drainRequestQueue: entry _writeState: " + this._writeState);
            }
            while ((requestBuffer = this._requestQueue.poll()) != null) {
                ChannelFuture writeFuture;
                InetSocketAddress local = (InetSocketAddress)this.channel.localAddress();
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport:drainRequestQueue: writing new message, length = " + requestBuffer.readableBytes() + " content as string: " + requestBuffer.toString(Charset.defaultCharset()) + " remote addr: " + this._currentSocketAddress + " local addr: " + local);
                }
                if (!(writeFuture = this.writeBufferAsDatagram(requestBuffer)).isDone()) {
                    this._writeState = 3;
                    writeFuture.addListener(f -> {
                        if (f.isSuccess()) {
                            this.writeComplete();
                        } else {
                            this.writeError((Exception)f.cause());
                        }
                    });
                    break block5;
                }
                this.writeComplete();
            }
            this._writeState = 2;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: drainRequestQueue: exit _writeState: " + this._writeState);
        }
    }

    private ChannelFuture writeBufferAsDatagram(ByteBuf requestBuffer) {
        return this.channel.writeAndFlush((Object)new DatagramPacket(requestBuffer, this._currentSocketAddress, (InetSocketAddress)this.channel.localAddress()));
    }

    static {
        _channelInitialized = false;
    }

    private class SipResolverUDPInitializer
    extends ChannelInitializerWrapper {
        ChannelInitializerWrapper parent;

        public SipResolverUDPInitializer(ChannelInitializerWrapper parent) {
            this.parent = parent;
        }

        protected void initChannel(Channel ch) throws Exception {
            if (this.parent != null) {
                this.parent.init(ch);
            }
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast("decoder", (ChannelHandler)new SipMessageBufferDatagramDecoder());
            pipeline.addLast(SipResolverUdpTransport.this.CHAINNAME, (ChannelHandler)new SipResolverUdpTransportHandler());
        }
    }

    private final class SipMessageBufferDatagramDecoder
    extends MessageToMessageDecoder<DatagramPacket> {
        private SipMessageBufferDatagramDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, DatagramPacket packet, List<Object> out) throws Exception {
            ByteBuf content = (ByteBuf)packet.content();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipMessageBufferDatagramDecoder decode packet length: " + content.readableBytes());
            }
            out.add(content.retain());
        }
    }

    private class SipResolverUdpTransportHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "channelRead0 message length: " + msg.readableBytes());
            }
            SipResolverUdpTransport.this.messageRead(ctx, msg.retain());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable e2) throws Exception {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "exceptionCaught: " + e2.getMessage());
            }
            SipResolverUdpTransport.this.readError(ctx, e2);
            ctx.close();
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "channelActive local: " + ctx.channel().localAddress() + " remote: " + ctx.channel().remoteAddress());
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "channelInactive remote disconnected: " + ctx.channel().remoteAddress());
            }
            SipResolverUdpTransport.this.channel = null;
        }
    }
}

