/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.address;

import com.ibm.ws.sip.parser.Coder;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.URI;

public class URIImpl
implements URI {
    private static final long serialVersionUID = -5197070550574020625L;
    protected String m_scheme;
    private String m_schemeData;

    URIImpl() {
    }

    public URIImpl(String scheme) {
        this.m_scheme = scheme;
    }

    URIImpl(String scheme, String schemeData) {
        this.m_scheme = scheme;
        this.m_schemeData = schemeData;
    }

    @Override
    public String getScheme() {
        return this.m_scheme;
    }

    @Override
    public String getSchemeData() {
        return this.m_schemeData;
    }

    @Override
    public void setScheme(String scheme) throws IllegalArgumentException, SipParseException {
        if (scheme == null) {
            throw new IllegalArgumentException("URI: Null scheme");
        }
        if (scheme.length() == 0) {
            throw new SipParseException("URI: Empty scheme", "");
        }
        this.m_scheme = scheme.equalsIgnoreCase("sip") ? "sip" : (scheme.equalsIgnoreCase("sips") ? "sips" : (scheme.equalsIgnoreCase("tel") ? "tel" : scheme));
    }

    @Override
    public void setSchemeData(String schemeData) throws IllegalArgumentException, SipParseException {
        if (schemeData == null) {
            throw new IllegalArgumentException("URI: null schemeData");
        }
        if (schemeData.length() == 0) {
            throw new SipParseException("URI: null scheme data");
        }
        this.m_schemeData = schemeData;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            e2.printStackTrace();
            throw new Error("Clone error");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof URIImpl)) {
            return false;
        }
        URIImpl other = (URIImpl)obj;
        if (!this.m_scheme.equals(other.getScheme())) {
            return false;
        }
        return !(this.m_schemeData == null ? other.getSchemeData() != null : !this.m_schemeData.equals(other.getSchemeData()));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        this.writeToCharBuffer(buffer);
        String value = buffer.toString();
        CharsBuffersPool.putBufferBack(buffer);
        return value;
    }

    public void writeToCharBuffer(CharsBuffer ret) {
        ret.append(this.m_scheme);
        if (this.m_schemeData != null) {
            ret.append(':');
            if (this.isTelURI()) {
                Coder.encodeTelURI(this.m_schemeData, ret);
            } else {
                Coder.encode(this.m_schemeData, ret);
            }
        }
    }

    private boolean isTelURI() {
        return this.m_scheme.equalsIgnoreCase("TEL") || this.m_scheme.equalsIgnoreCase("FAX") || this.m_scheme.equalsIgnoreCase("MODEM");
    }
}

