/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.annotations.Tool;
import io.openliberty.mcp.annotations.ToolArg;
import io.openliberty.mcp.annotations.WrapBusinessError;
import io.openliberty.mcp.internal.SpecialArgumentType;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public record ToolMetadata(Tool annotation, Bean<?> bean, AnnotatedMethod<?> method, Map<String, ArgumentMetadata> arguments, List<SpecialArgumentMetadata> specialArguments, String name, String title, String description, List<Class<? extends Throwable>> businessExceptions) {
    public static final String MISSING_TOOL_ARG_NAME = "<<<MISSING TOOL_ARG NAME>>>";
    static final long serialVersionUID = -7642357005725353172L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ToolMetadata {
        arguments = arguments == null ? Collections.emptyMap() : arguments;
        specialArguments = specialArguments == null ? Collections.emptyList() : specialArguments;
    }

    public static ToolMetadata createFrom(Tool annotation, Bean<?> bean, AnnotatedMethod<?> method) {
        String name = annotation.name().equals("<<element name>>") ? method.getJavaMember().getName() : annotation.name();
        String title = annotation.title().isEmpty() ? null : annotation.title();
        String description = annotation.description().isEmpty() ? null : annotation.description();
        WrapBusinessError wrapAnnotation = (WrapBusinessError)method.getAnnotation(WrapBusinessError.class);
        List<Class<? extends Throwable>> businessExceptions = wrapAnnotation != null ? List.of(wrapAnnotation.value()) : Collections.emptyList();
        return new ToolMetadata(annotation, bean, method, ToolMetadata.getArgumentMap(method), ToolMetadata.getSpecialArgumentList(method), name, title, description, businessExceptions);
    }

    private static Map<String, ArgumentMetadata> getArgumentMap(AnnotatedMethod<?> method) {
        HashMap<String, ArgumentMetadata> result = new HashMap<String, ArgumentMetadata>();
        for (AnnotatedParameter param : method.getParameters()) {
            ToolArg argAnnotation = (ToolArg)param.getAnnotation(ToolArg.class);
            if (argAnnotation == null) continue;
            String argName = ToolMetadata.resolveArgumentName(param, argAnnotation);
            boolean isDuplicateArg = result.containsKey(argName);
            result.put(argName, new ArgumentMetadata(param.getBaseType(), param.getPosition(), argAnnotation.description(), argAnnotation.required(), isDuplicateArg));
        }
        return result.isEmpty() ? Collections.emptyMap() : result;
    }

    private static String resolveArgumentName(AnnotatedParameter<?> param, ToolArg argAnnotation) {
        String argAnnotationName = argAnnotation.name();
        if (!argAnnotationName.equals("<<element name>>")) {
            return argAnnotationName;
        }
        if (param.getJavaParameter().isNamePresent()) {
            return param.getJavaParameter().getName();
        }
        return MISSING_TOOL_ARG_NAME;
    }

    private static List<SpecialArgumentMetadata> getSpecialArgumentList(AnnotatedMethod<?> method) {
        ArrayList<SpecialArgumentMetadata> result = new ArrayList<SpecialArgumentMetadata>();
        for (AnnotatedParameter p : method.getParameters()) {
            ToolArg pInfo = (ToolArg)p.getAnnotation(ToolArg.class);
            if (pInfo != null) continue;
            SpecialArgumentMetadata pData = new SpecialArgumentMetadata(SpecialArgumentType.fromClass(p.getBaseType()), p.getPosition());
            result.add(pData);
        }
        return Collections.unmodifiableList(result);
    }

    public String getToolQualifiedName() {
        return String.valueOf(this.bean.getBeanClass()) + "." + this.method.getJavaMember().getName();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.ToolMetadata", ToolMetadata.class, (String)"MCP", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record ArgumentMetadata(Type type, int index, String description, boolean required, boolean isDuplicate) {
        static final long serialVersionUID = -6407916160632911338L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.ToolMetadata$ArgumentMetadata", ArgumentMetadata.class, (String)"MCP", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record SpecialArgumentMetadata(SpecialArgumentType.Resolution typeResolution, int index) {
        static final long serialVersionUID = -6491920200958422337L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.ToolMetadata$SpecialArgumentMetadata", SpecialArgumentMetadata.class, (String)"MCP", null);
        }
    }
}

