/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.web.OAuth20EndpointServices;
import io.openliberty.security.common.http.SupportedHttpMethodHandler;
import io.openliberty.security.oauth20.web.OAuthSupportedHttpMethodHandler;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OAuth20EndpointServlet
extends HttpServlet {
    private static final String MESSAGE_BUNDLE = "com.ibm.ws.security.oauth20.internal.resources.OAuthMessages";
    private static final long serialVersionUID = 1L;
    private transient OAuth20EndpointServices oauthEndpointServices = null;
    private transient ServletContext servletContext = null;
    private transient BundleContext bundleContext = null;
    private transient ServiceReference<OAuth20EndpointServices> oauth20EndPointServicesRef = null;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void init() {
        this.servletContext = this.getServletContext();
        this.bundleContext = (BundleContext)this.servletContext.getAttribute("osgi-bundlecontext");
        this.oauth20EndPointServicesRef = this.bundleContext.getServiceReference(OAuth20EndpointServices.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isValidHttpMethodForRequest(request, response, SupportedHttpMethodHandler.HttpMethod.GET)) {
            return;
        }
        this.handleRequest(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isValidHttpMethodForRequest(request, response, SupportedHttpMethodHandler.HttpMethod.HEAD)) {
            return;
        }
        this.handleRequest(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isValidHttpMethodForRequest(request, response, SupportedHttpMethodHandler.HttpMethod.DELETE)) {
            return;
        }
        this.handleRequest(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isValidHttpMethodForRequest(request, response, SupportedHttpMethodHandler.HttpMethod.PUT)) {
            return;
        }
        this.handleRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isValidHttpMethodForRequest(request, response, SupportedHttpMethodHandler.HttpMethod.POST)) {
            return;
        }
        this.handleRequest(request, response);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        OAuthSupportedHttpMethodHandler optionsRequestHandler = this.getOAuthSupportedHttpMethodHandler(request, response);
        optionsRequestHandler.sendUnsupportedMethodResponse();
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        OAuthSupportedHttpMethodHandler optionsRequestHandler = this.getOAuthSupportedHttpMethodHandler(request, response);
        optionsRequestHandler.sendHttpOptionsResponse();
    }

    OAuthSupportedHttpMethodHandler getOAuthSupportedHttpMethodHandler(HttpServletRequest request, HttpServletResponse response) {
        return new OAuthSupportedHttpMethodHandler(request, response);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getOAuthEndpointServices();
        this.oauthEndpointServices.handleOAuthRequest(request, response, this.servletContext);
    }

    private synchronized OAuth20EndpointServices getOAuthEndpointServices() throws ServletException {
        if (this.oauth20EndPointServicesRef == null) {
            throw new ServletException(TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_OSGI_ENDPOINT_SERVICE_ERROR", null, (String)"CWWKS1616E: A configuration error has occurred. No endpoint service is available. Ensure that you have the openidConnectServer-1.0 feature configured."));
        }
        this.oauthEndpointServices = (OAuth20EndpointServices)this.bundleContext.getService(this.oauth20EndPointServicesRef);
        return this.oauthEndpointServices;
    }

    private boolean isValidHttpMethodForRequest(HttpServletRequest request, HttpServletResponse response, SupportedHttpMethodHandler.HttpMethod requestMethod) throws IOException {
        OAuthSupportedHttpMethodHandler optionsRequestHandler = this.getOAuthSupportedHttpMethodHandler(request, response);
        if (!optionsRequestHandler.isValidHttpMethodForRequest(requestMethod)) {
            optionsRequestHandler.sendUnsupportedMethodResponse();
            return false;
        }
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServlet", OAuth20EndpointServlet.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    }
}

