/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20;

import com.ibm.oauth.core.api.OAuthComponentInstance;
import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.oauth20.OAuth20Component;
import com.ibm.oauth.core.api.statistics.OAuthStatistics;
import com.ibm.oauth.core.internal.statistics.OAuthStatHelper;
import com.ibm.oauth.core.internal.statistics.OAuthStatisticsImpl;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class OAuth20ComponetImplWrapper
implements OAuth20Component {
    OAuth20Component _real;
    OAuthStatisticsImpl _stats;

    public OAuth20ComponetImplWrapper(OAuth20Component real, OAuthStatisticsImpl stats) {
        this._real = real;
        this._stats = stats;
    }

    @Override
    public OAuthComponentConfiguration getConfiguration() {
        return this._real.getConfiguration();
    }

    @Override
    public OAuthComponentInstance getParentComponentInstance() {
        return this._real.getParentComponentInstance();
    }

    @Override
    public OAuthStatistics getStatistics() {
        return this._real.getStatistics();
    }

    @Override
    public OAuthResult processAuthorization(String username, String clientId, String redirectUri, String responseType, String state, String[] authorizedScopes, HttpServletResponse response) {
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.processAuthorization");
        OAuthResult result = this._real.processAuthorization(username, clientId, redirectUri, responseType, state, authorizedScopes, response);
        this._stats.addMeasurement(statHelper);
        return result;
    }

    @Override
    public OAuthResult processAuthorization(HttpServletRequest request, HttpServletResponse response, AttributeList options) {
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.processAuthorization");
        OAuthResult result = this._real.processAuthorization(request, response, options);
        this._stats.addMeasurement(statHelper);
        return result;
    }

    @Override
    public OAuthResult processTokenRequest(String authenticatedClient, HttpServletRequest request, HttpServletResponse response) {
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.processToken");
        OAuthResult result = this._real.processTokenRequest(authenticatedClient, request, response);
        this._stats.addMeasurement(statHelper);
        return result;
    }

    @Override
    public OAuthResult processAppTokenRequest(boolean isAppPasswordRequest, String authenticatedClient, HttpServletRequest request, HttpServletResponse response) {
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.processAppToken");
        OAuthResult result = this._real.processAppTokenRequest(isAppPasswordRequest, authenticatedClient, request, response);
        this._stats.addMeasurement(statHelper);
        return result;
    }

    @Override
    public OAuthResult processResourceRequest(HttpServletRequest request) {
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.processResource");
        OAuthResult result = this._real.processResourceRequest(request);
        this._stats.addMeasurement(statHelper);
        return result;
    }

    @Override
    public OAuthResult processResourceRequest(AttributeList attributeList) {
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.processResource");
        OAuthResult result = this._real.processResourceRequest(attributeList);
        this._stats.addMeasurement(statHelper);
        return result;
    }
}

