/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import io.openliberty.restfulWS.utils.RestfulWSUtils;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.ResteasyDeploymentImpl;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.server.servlet.ConfigurationBootstrap;
import org.jboss.resteasy.plugins.server.servlet.HttpRequestFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpResponseFactory;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.Dispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ServletContainerDispatcher {
    protected Dispatcher dispatcher;
    protected ResteasyProviderFactory providerFactory;
    private String servletMappingPrefix = "";
    protected ResteasyDeployment deployment = null;
    protected HttpRequestFactory requestFactory;
    protected HttpResponseFactory responseFactory;
    protected ServletConfig servletConfig;
    static final long serialVersionUID = 1726471582803906859L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ServletContainerDispatcher(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        ResteasyContext.pushContext(ServletConfig.class, servletConfig);
        RestfulWSUtils.logEndpoints(servletConfig);
    }

    public ServletContainerDispatcher() {
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletContext servletContext, ConfigurationBootstrap bootstrap, HttpRequestFactory requestFactory, HttpResponseFactory responseFactory) throws ServletException {
        boolean useGlobal;
        Dispatcher globalDispatcher;
        this.requestFactory = requestFactory;
        this.responseFactory = responseFactory;
        ResteasyDeployment ctxDeployment = (ResteasyDeployment)servletContext.getAttribute(ResteasyDeployment.class.getName());
        ResteasyProviderFactory globalFactory = (ResteasyProviderFactory)servletContext.getAttribute(ResteasyProviderFactory.class.getName());
        if (globalFactory == null && ctxDeployment != null) {
            globalFactory = ctxDeployment.getProviderFactory();
        }
        if ((globalDispatcher = (Dispatcher)servletContext.getAttribute(Dispatcher.class.getName())) == null && ctxDeployment != null) {
            globalDispatcher = ctxDeployment.getDispatcher();
        }
        String application = bootstrap.getInitParameter("jakarta.ws.rs.Application");
        String useGlobalStr = bootstrap.getInitParameter("resteasy.servlet.context.deployment");
        boolean bl = useGlobal = globalFactory != null;
        if (useGlobalStr != null) {
            useGlobal = Boolean.parseBoolean(useGlobalStr);
        }
        if (useGlobal) {
            this.providerFactory = globalFactory;
            this.dispatcher = globalDispatcher;
            if (this.providerFactory != null && this.dispatcher == null || this.providerFactory == null && this.dispatcher != null) {
                throw new ServletException(Messages.MESSAGES.unknownStateListener());
            }
            if (this.providerFactory == null) {
                this.deployment = bootstrap.createDeployment();
                this.deployment.start();
                servletContext.setAttribute(ResteasyProviderFactory.class.getName(), (Object)this.deployment.getProviderFactory());
                servletContext.setAttribute(Dispatcher.class.getName(), (Object)this.deployment.getDispatcher());
                servletContext.setAttribute(Registry.class.getName(), (Object)this.deployment.getRegistry());
                this.dispatcher = this.deployment.getDispatcher();
                this.providerFactory = this.deployment.getProviderFactory();
            } else if (application != null) {
                try {
                    Map<Class<?>, Object> contextDataMap = ResteasyContext.getContextDataMap();
                    contextDataMap.putAll(this.dispatcher.getDefaultContextObjects());
                    Application app = ResteasyDeploymentImpl.createApplication(application.trim(), this.dispatcher, this.providerFactory);
                    this.processApplication(app);
                    this.servletMappingPrefix = this.getServletMappingPrefix(bootstrap);
                }
                finally {
                    ResteasyContext.removeContextDataLevel();
                }
            } else {
                this.servletMappingPrefix = this.getServletMappingPrefix(bootstrap);
            }
        } else {
            this.servletMappingPrefix = this.getServletMappingPrefix(bootstrap);
            this.deployment = bootstrap.createDeployment();
            this.deployment.start();
            this.dispatcher = this.deployment.getDispatcher();
            this.providerFactory = this.deployment.getProviderFactory();
        }
    }

    private String getServletMappingPrefix(ConfigurationBootstrap bootstrap) {
        String servletMappingPrefix = bootstrap.getInitParameter("resteasy.servlet.mapping.prefix");
        if (servletMappingPrefix == null) {
            servletMappingPrefix = bootstrap.getParameter("resteasy.servlet.mapping.prefix");
        }
        if (servletMappingPrefix == null) {
            servletMappingPrefix = "";
        }
        servletMappingPrefix = servletMappingPrefix.trim();
        return servletMappingPrefix;
    }

    public void destroy() {
        if (this.deployment != null) {
            this.deployment.stop();
        }
    }

    protected void processApplication(Application config) {
        LogMessages.LOGGER.deployingApplication(Application.class.getName(), config.getClass());
        ArrayList<Class> actualResourceClasses = new ArrayList<Class>();
        ArrayList<Class> actualProviderClasses = new ArrayList<Class>();
        ArrayList resources = new ArrayList();
        ArrayList providers = new ArrayList();
        if (config.getClasses() != null) {
            for (Class clazz : config.getClasses()) {
                if (GetRestful.isRootResource(clazz)) {
                    LogMessages.LOGGER.addingClassResource(clazz.getName(), config.getClass());
                    actualResourceClasses.add(clazz);
                    continue;
                }
                LogMessages.LOGGER.addingProviderClass(clazz.getName(), config.getClass());
                actualProviderClasses.add(clazz);
            }
        }
        if (config.getSingletons() != null) {
            for (Object obj : config.getSingletons()) {
                if (GetRestful.isRootResource(obj.getClass())) {
                    LogMessages.LOGGER.addingSingletonResource(obj.getClass().getName(), config.getClass());
                    resources.add(obj);
                    continue;
                }
                LogMessages.LOGGER.addingSingletonProvider(obj.getClass().getName(), config.getClass());
                providers.add(obj);
            }
        }
        for (Class clazz : actualProviderClasses) {
            this.providerFactory.registerProvider(clazz);
        }
        for (Object obj : providers) {
            this.providerFactory.registerProviderInstance(obj);
        }
        for (Class clazz : actualResourceClasses) {
            this.dispatcher.getRegistry().addPerRequestResource(clazz);
        }
        for (Object obj : resources) {
            this.dispatcher.getRegistry().addSingletonResource(obj);
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(String httpMethod, HttpServletRequest request, HttpServletResponse response, boolean handleNotFound) throws IOException, NotFoundException {
        try {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.push(this.providerFactory);
            }
            ResteasyHttpHeaders headers = null;
            ResteasyUriInfo uriInfo = null;
            try {
                headers = ServletUtil.extractHttpHeaders(request);
                uriInfo = ServletUtil.extractUriInfo(request, this.servletMappingPrefix);
            }
            catch (Exception e) {
                response.sendError(400);
                LogMessages.LOGGER.failedToParseRequest(e);
                ResteasyProviderFactory defaultInstance2 = ResteasyProviderFactory.getInstance();
                if (defaultInstance2 instanceof ThreadLocalResteasyProviderFactory) {
                    ThreadLocalResteasyProviderFactory.pop();
                }
                return;
            }
            try (HttpResponse theResponse = this.responseFactory.createResteasyHttpResponse(response, request);){
                HttpRequest in = this.requestFactory.createResteasyHttpRequest(httpMethod, request, headers, uriInfo, theResponse, response);
                ResteasyContext.pushContext(HttpServletRequest.class, request);
                ResteasyContext.pushContext(HttpServletResponse.class, response);
                ResteasyContext.pushContext(SecurityContext.class, new ServletSecurityContext(request));
                ResteasyContext.pushContext(ServletConfig.class, this.servletConfig);
                if (handleNotFound) {
                    this.dispatcher.invoke(in, theResponse);
                } else {
                    ((SynchronousDispatcher)this.dispatcher).invokePropagateNotFound(in, theResponse);
                }
            }
            finally {
                ResteasyContext.clearContextData();
            }
        }
        finally {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.pop();
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.ServletContainerDispatcher", ServletContainerDispatcher.class, null, null);
    }
}

