/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.transactions;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.utils.Base64Utils;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.transaction.xa.Xid;

public class PersistentTranId
implements Xid {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.transactions.CWSJSMessages");
    private static TraceComponent tc = SibTr.register(PersistentTranId.class, (String)"SIBTransactions", (String)"com.ibm.ws.sib.transactions.CWSJSMessages");
    private int _hashCode = -1;
    private final int _formatId;
    private final byte[] _gtrid;
    private final byte[] _bqual;
    private String _persistentData = null;

    public PersistentTranId(int tranid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("TranId=" + tranid));
        }
        this._formatId = tranid;
        this._hashCode = tranid;
        this._gtrid = this.intToBytes(tranid);
        this._bqual = this.intToBytes(tranid);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public PersistentTranId(int formatId, byte[] gtrid, byte[] bqual) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{"FormatId=" + formatId, "GTRID=" + Base64Utils.encodeBase64((byte[])gtrid), "BQUAL=" + Base64Utils.encodeBase64((byte[])bqual)});
        }
        this._formatId = formatId;
        this._gtrid = gtrid;
        this._bqual = bqual;
        if (this._bqual.length > 16) {
            this._hashCode = ((this._bqual[12] & 0xFF) << 24) + ((this._bqual[13] & 0xFF) << 16) + ((this._bqual[14] & 0xFF) << 8) + (this._bqual[15] & 0xFF);
        } else if (this._bqual.length > 3) {
            this._hashCode = ((this._bqual[this._bqual.length - 4] & 0xFF) << 24) + ((this._bqual[this._bqual.length - 3] & 0xFF) << 16) + ((this._bqual[this._bqual.length - 2] & 0xFF) << 8) + (this._bqual[this._bqual.length - 1] & 0xFF);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public PersistentTranId(Xid xid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("Xid=" + xid));
        }
        this._formatId = xid.getFormatId();
        this._gtrid = xid.getGlobalTransactionId();
        this._bqual = xid.getBranchQualifier();
        if (this._bqual.length > 16) {
            this._hashCode = ((this._bqual[12] & 0xFF) << 24) + ((this._bqual[13] & 0xFF) << 16) + ((this._bqual[14] & 0xFF) << 8) + (this._bqual[15] & 0xFF);
        } else if (this._bqual.length > 3) {
            this._hashCode = ((this._bqual[this._bqual.length - 4] & 0xFF) << 24) + ((this._bqual[this._bqual.length - 3] & 0xFF) << 16) + ((this._bqual[this._bqual.length - 2] & 0xFF) << 8) + (this._bqual[this._bqual.length - 1] & 0xFF);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public PersistentTranId(byte[] bytes) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("Byte Data=" + Base64Utils.encodeBase64((byte[])bytes)));
        }
        byte[] tempint = new byte[4];
        System.arraycopy(bytes, 0, tempint, 0, 4);
        this._formatId = this.bytesToInt(tempint);
        System.arraycopy(bytes, 4, tempint, 0, 4);
        int gtridlen = this.bytesToInt(tempint);
        this._gtrid = new byte[gtridlen];
        System.arraycopy(bytes, 8, this._gtrid, 0, gtridlen);
        System.arraycopy(bytes, 8 + gtridlen, tempint, 0, 4);
        int bquallen = this.bytesToInt(tempint);
        this._bqual = new byte[bquallen];
        System.arraycopy(bytes, 12 + gtridlen, this._bqual, 0, bquallen);
        if (this._bqual.length > 16) {
            this._hashCode = ((this._bqual[12] & 0xFF) << 24) + ((this._bqual[13] & 0xFF) << 16) + ((this._bqual[14] & 0xFF) << 8) + (this._bqual[15] & 0xFF);
        } else if (this._bqual.length > 3) {
            this._hashCode = ((this._bqual[this._bqual.length - 4] & 0xFF) << 24) + ((this._bqual[this._bqual.length - 3] & 0xFF) << 16) + ((this._bqual[this._bqual.length - 2] & 0xFF) << 8) + (this._bqual[this._bqual.length - 1] & 0xFF);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public PersistentTranId(String data) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("String Data=" + data));
        }
        this._persistentData = data;
        byte[] bytes = data.charAt(0) == '!' ? Base64Utils.decodeBase64((String)data) : this.fromHexString(data);
        byte[] tempint = new byte[4];
        System.arraycopy(bytes, 0, tempint, 0, 4);
        this._formatId = this.bytesToInt(tempint);
        System.arraycopy(bytes, 4, tempint, 0, 4);
        int gtridlen = this.bytesToInt(tempint);
        this._gtrid = new byte[gtridlen];
        System.arraycopy(bytes, 8, this._gtrid, 0, gtridlen);
        System.arraycopy(bytes, 8 + gtridlen, tempint, 0, 4);
        int bquallen = this.bytesToInt(tempint);
        this._bqual = new byte[bquallen];
        System.arraycopy(bytes, 12 + gtridlen, this._bqual, 0, bquallen);
        if (this._bqual.length > 16) {
            this._hashCode = ((this._bqual[12] & 0xFF) << 24) + ((this._bqual[13] & 0xFF) << 16) + ((this._bqual[14] & 0xFF) << 8) + (this._bqual[15] & 0xFF);
        } else if (this._bqual.length > 3) {
            this._hashCode = ((this._bqual[this._bqual.length - 4] & 0xFF) << 24) + ((this._bqual[this._bqual.length - 3] & 0xFF) << 16) + ((this._bqual[this._bqual.length - 2] & 0xFF) << 8) + (this._bqual[this._bqual.length - 1] & 0xFF);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public int getFormatId() {
        return this._formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this._gtrid;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this._bqual;
    }

    public String getPersistentData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistentData");
        }
        if (this._persistentData == null) {
            this._persistentData = Base64Utils.encodeBase64((byte[])this.toByteArray());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistentData", (Object)("return=" + this._persistentData));
        }
        return this._persistentData;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PersistentTranId)) {
            return false;
        }
        PersistentTranId ptid = (PersistentTranId)obj;
        int formatId = ptid.getFormatId();
        byte[] gtrid = ptid.getGlobalTransactionId();
        byte[] bqual = ptid.getBranchQualifier();
        if (this._formatId != formatId || this._gtrid.length != gtrid.length || this._bqual.length != bqual.length) {
            return false;
        }
        int i = this._bqual.length;
        while (--i >= 0) {
            if (this._bqual[i] == bqual[i]) continue;
            return false;
        }
        i = this._gtrid.length;
        while (--i >= 0) {
            if (this._gtrid[i] == gtrid[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return this.getPersistentData();
    }

    public String toTMString() {
        StringBuffer retval = new StringBuffer();
        retval.append(this.toHexString(this._gtrid));
        retval.append(this.toHexString(this._bqual));
        return retval.toString();
    }

    public byte[] toByteArray() {
        byte[] retval = new byte[12 + this._gtrid.length + this._bqual.length];
        byte[] tempint = new byte[4];
        tempint = this.intToBytes(this._formatId);
        System.arraycopy(tempint, 0, retval, 0, 4);
        tempint = this.intToBytes(this._gtrid.length);
        System.arraycopy(tempint, 0, retval, 4, 4);
        System.arraycopy(this._gtrid, 0, retval, 8, this._gtrid.length);
        tempint = this.intToBytes(this._bqual.length);
        System.arraycopy(tempint, 0, retval, 8 + this._gtrid.length, 4);
        System.arraycopy(this._bqual, 0, retval, 12 + this._gtrid.length, this._bqual.length);
        return retval;
    }

    private int bytesToInt(byte[] bytes) {
        int result = -1;
        if (bytes.length >= 4) {
            result = ((bytes[0] & 0xFF) << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + (bytes[3] & 0xFF);
        }
        return result;
    }

    private byte[] intToBytes(int Int) {
        return new byte[]{(byte)(Int >> 24), (byte)(Int >> 16), (byte)(Int >> 8), (byte)Int};
    }

    private String toHexString(byte[] b) {
        String digits = "0123456789abcdef";
        StringBuffer retval = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            retval.append(digits.charAt(b[i] >> 4 & 0xF));
            retval.append(digits.charAt(b[i] & 0xF));
        }
        return retval.toString();
    }

    private byte[] fromHexString(String hex) {
        String digits = "0123456789abcdef";
        byte[] retval = new byte[hex.length() / 2];
        int position = 0;
        for (int i = 0; i < hex.length(); i += 2) {
            int highorderbits = digits.indexOf(hex.charAt(i));
            int loworderbits = digits.indexOf(hex.charAt(i + 1));
            if (highorderbits < 0 || highorderbits > 15 || loworderbits < 0 || loworderbits > 15) {
                if (tc.isEntryEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid values found restoring Xid from String data. HO=" + highorderbits + ", LO=" + loworderbits));
                }
                throw new SIErrorException(nls.getString("UNRECOVERABLE_ERROR_CWSJS0007"));
            }
            retval[position] = (byte)(highorderbits << 4 | loworderbits);
            ++position;
        }
        return retval;
    }
}

