/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.yoko.util.TriFunction;

public enum Exceptions {


    public static <EXC extends Throwable> EXC as(Supplier<EXC> constructor, Throwable cause) {
        Throwable exc = (Throwable)constructor.get();
        return (EXC)Exceptions.withCause(exc, cause);
    }

    public static <EXC extends Throwable, ARG> EXC as(Function<ARG, EXC> constructor, Throwable cause, ARG arg) {
        Throwable exc = (Throwable)constructor.apply(arg);
        return (EXC)Exceptions.withCause(exc, cause);
    }

    public static <EXC extends Throwable, ARG1, ARG2> EXC as(BiFunction<ARG1, ARG2, EXC> constructor, Throwable cause, ARG1 arg1, ARG2 arg2) {
        Throwable exc = (Throwable)constructor.apply(arg1, arg2);
        return (EXC)Exceptions.withCause(exc, cause);
    }

    public static <EXC extends Throwable, ARG1, ARG2, ARG3> EXC as(TriFunction<ARG1, ARG2, ARG3, EXC> constructor, Throwable cause, ARG1 arg1, ARG2 arg2, ARG3 arg3) {
        Throwable exc = (Throwable)constructor.apply(arg1, arg2, arg3);
        return (EXC)Exceptions.withCause(exc, cause);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String describeException(Throwable e) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                e.printStackTrace(pw);
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ignored) {
            return "";
        }
    }

    private static <EXC extends Throwable> EXC withCause(EXC exc, Throwable cause) {
        if (exc instanceof RemoteException) {
            ((RemoteException)exc).detail = cause;
        } else {
            exc.initCause(cause);
        }
        return exc;
    }
}

