/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.serialization.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serialization.SerializationContext;
import com.ibm.ws.serialization.SerializationObjectReplacer;
import com.ibm.ws.serialization.internal.SerializationObjectOutputStreamImpl;
import com.ibm.ws.serialization.internal.SerializationServiceImpl;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SerializationContextImpl
implements SerializationContext {
    private final SerializationServiceImpl service;
    private List<SerializationObjectReplacer> replacers;
    static final long serialVersionUID = -7526285007192466700L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SerializationContextImpl(SerializationServiceImpl service) {
        this.service = service;
    }

    @Override
    public void addObjectReplacer(SerializationObjectReplacer replacer) {
        if (this.replacers == null) {
            this.replacers = new ArrayList<SerializationObjectReplacer>();
        }
        this.replacers.add(replacer);
    }

    @Override
    public ObjectOutputStream createObjectOutputStream(OutputStream output) throws IOException {
        return new SerializationObjectOutputStreamImpl(output, this);
    }

    public boolean isReplaceObjectNeeded() {
        return this.replacers != null || this.service.isReplaceObjectNeeded();
    }

    @Sensitive
    public Object replaceObject(@Sensitive Object object) {
        if (this.replacers != null) {
            for (SerializationObjectReplacer replacer : this.replacers) {
                Object replacedObject = replacer.replaceObject(object);
                if (replacedObject == null) continue;
                return replacedObject;
            }
        }
        return this.service.replaceObject(object);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.serialization.internal.SerializationContextImpl", SerializationContextImpl.class, (String)"serialization", null);
    }
}

