/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jfap.inbound.channel;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jfap.inbound.channel.CommsInboundChain;
import com.ibm.ws.jfap.inbound.channel.InboundChain;
import com.ibm.ws.jfap.inbound.channel.InboundSecureFacet;
import com.ibm.ws.jfap.inbound.channel.JFAPServerInboundChannelFactory;
import com.ibm.ws.jfap.inbound.channel.NettyInboundChain;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.messaging.lifecycle.Singleton;
import com.ibm.ws.messaging.lifecycle.SingletonsReady;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.common.service.CommonServiceFacade;
import com.ibm.ws.sib.jfapchannel.server.ServerConnectionManager;
import com.ibm.ws.sib.mfp.trm.TrmMessageFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ChannelConfiguration;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.tls.NettyTlsProvider;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.ibm.ws.messaging.comms.server"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"type=messaging.comms.server.service", "nettyTlsProvider.cardinality.minimum=1", "service.vendor=IBM"})
public class CommsServerServiceFacade
implements Singleton {
    private static final String SECURE_PORT = "wasJmsSSLPort";
    private static final String BASIC_PORT = "wasJmsPort";
    private static final String CONFIG_ALIAS = "wasJmsEndpoint";
    private static final TraceComponent tc = Tr.register(CommsServerServiceFacade.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private final InboundChain inboundBasicChain;
    private final InboundChain inboundSecureChain;
    private final boolean useNettyTransport;
    private int basicPort;
    private int securePort;
    private String host = null;
    private boolean iswasJmsEndpointEnabled = true;
    private final JsAdminService jsAdminService;
    private final CHFWBundle chfw;
    private final NettyFramework nettyBundle;
    private final ChannelConfiguration tcpOptions;
    private final AtomicReference<InboundSecureFacet> secureFacetRef = new AtomicReference();
    private NettyTlsProvider nettyTlsProvider;
    private final EventEngine eventEngine;
    private final SynchronizedActions factotum = new SynchronizedActions();

    @Activate
    public CommsServerServiceFacade(@Reference(name="jsAdminService") JsAdminService jsAdminService, @Reference(name="chfw") CHFWBundle chfw, @Reference(name="nettyBundle") NettyFramework nettyBundle, @Reference(name="nettyTlsProvider", cardinality=ReferenceCardinality.OPTIONAL) NettyTlsProvider nettyTlsProvider, @Reference(name="tcpOptions", target="(id=unbound)") ChannelConfiguration tcpOptions, @Reference(name="eventEngine") EventEngine eventEngine, Map<String, Object> properties) {
        String methodName = "<init>";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{jsAdminService, nettyBundle, chfw, tcpOptions, eventEngine, properties});
        }
        this.jsAdminService = jsAdminService;
        this.chfw = chfw;
        this.nettyBundle = nettyBundle;
        this.tcpOptions = tcpOptions;
        this.eventEngine = eventEngine;
        this.nettyTlsProvider = nettyTlsProvider;
        ServerConnectionManager.initialise(chfw.getFramework());
        chfw.getFramework().registerFactory("JFAPChannel", JFAPServerInboundChannelFactory.class);
        this.useNettyTransport = ProductInfo.getBetaEdition() && MetatypeUtils.parseBoolean((Object)CONFIG_ALIAS, (String)"useNettyTransport", (Object)properties.get("useNettyTransport"), (boolean)true);
        Object cid = properties.get("component.id");
        String endpointName = (String)properties.get("id");
        if (endpointName == null) {
            endpointName = CONFIG_ALIAS + cid;
        }
        if (this.useNettyTransport) {
            this.inboundBasicChain = new NettyInboundChain(this, false).init(endpointName, this.nettyBundle);
            this.inboundSecureChain = new NettyInboundChain(this, true).init(endpointName + "-ssl", this.nettyBundle);
        } else {
            this.inboundBasicChain = new CommsInboundChain(this, false).init(endpointName, this.chfw);
            this.inboundSecureChain = new CommsInboundChain(this, true).init(endpointName + "-ssl", this.chfw);
        }
        this.modified0(properties, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this.modified0(properties, false);
    }

    private void modified0(Map<String, Object> properties, boolean fromActivate) {
        if (!fromActivate) {
            boolean modifiedUseNetty;
            boolean bl = modifiedUseNetty = ProductInfo.getBetaEdition() && MetatypeUtils.parseBoolean((Object)CONFIG_ALIAS, (String)"useNettyTransport", (Object)properties.get("useNettyTransport"), (boolean)true);
            if (modifiedUseNetty != this.useNettyTransport) {
                throw new IllegalStateException("Cannot change useNettyTransport.");
            }
        }
        this.iswasJmsEndpointEnabled = MetatypeUtils.parseBoolean((Object)CONFIG_ALIAS, (String)"enabled", (Object)properties.get("enabled"), (boolean)true);
        this.host = (String)properties.get("host");
        this.basicPort = MetatypeUtils.parseInteger((Object)CONFIG_ALIAS, (String)BASIC_PORT, (Object)properties.get(BASIC_PORT), (int)-1);
        this.securePort = MetatypeUtils.parseInteger((Object)CONFIG_ALIAS, (String)SECURE_PORT, (Object)properties.get(SECURE_PORT), (int)-1);
        this.inboundBasicChain.enable(this.basicPort >= 0);
        if (this.iswasJmsEndpointEnabled) {
            CheckpointPhase.onRestore(() -> this.factotum.updateBasicChain());
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"wasjmsEndpoint disabled: .. stopping chains");
            }
            this.factotum.stopBasicChain(false);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("CommsServerServiceFacade deactivated, reason=" + reason), (Object[])new Object[0]);
        }
        this.factotum.stopBasicChain(true);
    }

    public NettyTlsProvider getNettyTlsProvider() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNettyTlsProvider");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNettyTlsProvider", (Object)this.nettyTlsProvider);
        }
        return this.nettyTlsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="secureFacet", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="unbindSecureFacet")
    void bindSecureFacet(InboundSecureFacet facet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"bindSecureFacet", (Object)facet);
        }
        if (this.securePort >= 0 && facet.areSecureSocketsEnabled()) {
            this.inboundSecureChain.enable(true);
        }
        SynchronizedActions synchronizedActions = this.factotum;
        synchronized (synchronizedActions) {
            this.secureFacetRef.set(facet);
            CheckpointPhase.onRestore(() -> this.factotum.updateSecureChain());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindSecureFacet(InboundSecureFacet facet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unbindSecureFacet", (Object)facet);
        }
        SynchronizedActions synchronizedActions = this.factotum;
        synchronized (synchronizedActions) {
            if (this.secureFacetRef.compareAndSet(facet, null)) {
                this.factotum.stopSecureChain();
            }
        }
    }

    void closeViaCommsMPConnections(int mode) {
        this.factotum.closeViaCommsMPConnection(mode);
    }

    public static WsByteBufferPoolManager getBufferPoolManager() {
        return ((CommsServerServiceFacade)SingletonsReady.requireService(CommsServerServiceFacade.class)).chfw.getBufferManager();
    }

    Map<String, Object> getTcpOptions() {
        return this.tcpOptions.getConfiguration();
    }

    Map<String, Object> getSslOptions() {
        return Optional.of(this.secureFacetRef).map(ref -> (InboundSecureFacet)ref.get()).filter(f -> f.areSecureSocketsEnabled()).map(f -> f.getOptions()).map(o -> o.getConfiguration()).orElseGet(() -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"getSslOptions() returning NULL");
            }
            return null;
        });
    }

    public static TrmMessageFactory getTrmMessageFactory() {
        return TrmMessageFactory.getInstance();
    }

    public static JsAdminService getJsAdminService() {
        return CommonServiceFacade.getJsAdminService();
    }

    public EventEngine getEventEngine() {
        return this.eventEngine;
    }

    int getBasicPort() {
        return this.basicPort;
    }

    int getSecurePort() {
        return this.securePort;
    }

    String getHost() {
        return this.host;
    }

    private final class SynchronizedActions {
        boolean deactivated;

        private SynchronizedActions() {
        }

        synchronized void updateBasicChain() {
            block4: {
                if (CommsServerServiceFacade.this.iswasJmsEndpointEnabled) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"CommsServerServiceFacade: updating basic chain ", (Object)CommsServerServiceFacade.this.inboundBasicChain);
                    }
                    try {
                        CommsServerServiceFacade.this.inboundBasicChain.update();
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                        SibTr.debug((TraceComponent)tc, (String)"Exception in updating basic chain", (Object)e);
                    }
                }
            }
        }

        synchronized void updateSecureChain() {
            block4: {
                if (CommsServerServiceFacade.this.iswasJmsEndpointEnabled) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"CommsServerServiceFacade: updating secure chain ", (Object)CommsServerServiceFacade.this.inboundSecureChain);
                    }
                    try {
                        CommsServerServiceFacade.this.inboundSecureChain.update();
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                        SibTr.debug((TraceComponent)tc, (String)"Exception in updating secure chain", (Object)e);
                    }
                }
            }
        }

        synchronized void closeViaCommsMPConnection(int mode) {
            JsEngineComponent _mp;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"CommsServerServiceFacade.SynchronizedActions closeViaCommsMPConnection", (Object[])new Object[]{this.deactivated, mode});
            }
            if (this.deactivated) {
                return;
            }
            JsMessagingEngine local_ME = CommsServerServiceFacade.this.jsAdminService.getMessagingEngine("defaultBus", "defaultME");
            if (null != local_ME && null != (_mp = local_ME.getMessageProcessor())) {
                _mp.stop(mode);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"closeViaCommsMPConnection");
            }
        }

        synchronized void stopBasicChain(boolean deactivate) {
            block3: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"CommsServerServiceFacade: stopping basic chain ", (Object)CommsServerServiceFacade.this.inboundBasicChain);
                }
                try {
                    CommsServerServiceFacade.this.inboundBasicChain.stop();
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    SibTr.debug((TraceComponent)tc, (String)"Exception in stopping basic chain", (Object)e);
                }
            }
            this.deactivated = deactivate;
        }

        synchronized void stopSecureChain() {
            block3: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"CommsServerServiceFacade: stopping secure chain ", (Object)CommsServerServiceFacade.this.inboundSecureChain);
                }
                try {
                    CommsServerServiceFacade.this.inboundSecureChain.stop();
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    SibTr.debug((TraceComponent)tc, (String)"Exception in secure chain stopping", (Object)e);
                }
            }
        }
    }
}

