/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.strategies.writeable;

import com.ibm.ws.repository.common.enums.DisplayPolicy;
import com.ibm.ws.repository.common.enums.FilterPredicate;
import com.ibm.ws.repository.common.enums.FilterableAttribute;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.State;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.exceptions.RepositoryResourceValidationException;
import com.ibm.ws.repository.resources.ApplicableToProduct;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.internal.AppliesToProcessor;
import com.ibm.ws.repository.resources.internal.EsaResourceImpl;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import com.ibm.ws.repository.resources.writeable.ProductResourceWritable;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.resources.writeable.WebDisplayable;
import com.ibm.ws.repository.strategies.writeable.AddThenDeleteStrategy;
import com.ibm.ws.repository.strategies.writeable.Version4Digit;
import com.ibm.ws.repository.transport.model.AppliesToFilterInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddThenHideOldStrategy
extends AddThenDeleteStrategy {
    private static final Version4Digit MAX_VERSION = new Version4Digit(Integer.MAX_VALUE, 0, 0, "0");
    private static final Version4Digit MIN_VERSION = new Version4Digit(0, 0, 0, "0");

    public AddThenHideOldStrategy() {
    }

    public AddThenHideOldStrategy(State desiredStateIfMatchingFound, State desiredStateIfNoMatchingFound) {
        super(desiredStateIfMatchingFound, desiredStateIfNoMatchingFound, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadAsset(RepositoryResourceImpl newResource, List<RepositoryResourceImpl> matchingResources) throws RepositoryBackendException, RepositoryResourceException {
        String lockString;
        newResource.resetId();
        State desired = matchingResources.size() != 0 ? this.calculateTargetState(matchingResources.get(0)) : this._desiredStateIfNoMatchingFound;
        boolean performHideOnOldResource = false;
        List<Object> resourcesToHide = new ArrayList();
        String string = lockString = AddThenHideOldStrategy.getVanityUrlLock(newResource.getVanityURL());
        synchronized (string) {
            if (desired == State.PUBLISHED) {
                if (newResource instanceof EsaResourceImpl) {
                    EsaResourceImpl esa = (EsaResourceImpl)newResource;
                    if (this.isBeta(newResource) && Visibility.PUBLIC.equals((Object)esa.getVisibility())) {
                        esa.setWebDisplayPolicy(DisplayPolicy.VISIBLE);
                    }
                }
                if ((resourcesToHide = this.findResourcesToHide(newResource, matchingResources)).size() != 0) {
                    for (RepositoryResource repositoryResource : resourcesToHide) {
                        if (repositoryResource.getId() == null) {
                            if (!(repositoryResource instanceof WebDisplayable)) continue;
                            ((WebDisplayable)((Object)repositoryResource)).setWebDisplayPolicy(DisplayPolicy.HIDDEN);
                            continue;
                        }
                        performHideOnOldResource = true;
                    }
                }
            }
            super.uploadAsset(newResource, matchingResources);
            String newlyAddedAssetId = newResource.getId();
            if (performHideOnOldResource) {
                for (RepositoryResource repositoryResource : resourcesToHide) {
                    if (repositoryResource.getId().equals(newlyAddedAssetId) || !(repositoryResource instanceof WebDisplayable)) continue;
                    ((WebDisplayable)((Object)repositoryResource)).setWebDisplayPolicy(DisplayPolicy.HIDDEN);
                    RepositoryResourceWritable rrw = (RepositoryResourceWritable)repositoryResource;
                    rrw.uploadToMassive(new AddThenDeleteStrategy(rrw.getState(), State.DRAFT, true));
                }
            }
        }
    }

    private List<RepositoryResource> findResourcesToHide(RepositoryResourceImpl newResource, List<RepositoryResourceImpl> matchingResources) throws RepositoryBackendException, RepositoryResourceException {
        ArrayList<String> matchingResourceIds = new ArrayList<String>();
        for (RepositoryResourceImpl r : matchingResources) {
            matchingResourceIds.add(r.getId());
        }
        String vanityURL = newResource.getVanityURL();
        RepositoryConnection repo = newResource.getRepositoryConnection();
        Collection<RepositoryResource> resourcesWithSameVanityURLs = repo.getMatchingResources(FilterPredicate.areEqual(FilterableAttribute.VANITY_URL, vanityURL));
        ArrayList<RepositoryResource> resourcesToHide = new ArrayList<RepositoryResource>();
        RepositoryResource newestResource = newResource;
        for (RepositoryResource resource : resourcesWithSameVanityURLs) {
            if (!this.isVisibleAndWebDisplayable(resource) || !State.PUBLISHED.equals((Object)((RepositoryResourceWritable)resource).getState()) || matchingResourceIds.contains(resource.getId())) continue;
            newestResource = this.getNewerResource(newestResource, resource);
            resourcesToHide.add(resource);
        }
        resourcesToHide.remove(newestResource);
        if (newestResource != newResource) {
            resourcesToHide.add(newResource);
        }
        return resourcesToHide;
    }

    private RepositoryResource getNewerResource(RepositoryResource res1, RepositoryResource res2) throws RepositoryResourceValidationException {
        RepositoryResource singleNonBetaResource = this.returnNonBetaResourceOrNull(res1, res2);
        if (singleNonBetaResource != null) {
            return singleNonBetaResource;
        }
        if (res1.getType() == ResourceType.INSTALL) {
            Version4Digit res1Version = null;
            Version4Digit res2Version = null;
            try {
                res1Version = new Version4Digit(((ProductResourceWritable)res1).getProductVersion());
            }
            catch (IllegalArgumentException iae) {
                throw new RepositoryResourceValidationException("The product version was invalid: " + res1Version, res1.getId(), iae);
            }
            try {
                res2Version = new Version4Digit(((ProductResourceWritable)res2).getProductVersion());
            }
            catch (IllegalArgumentException iae) {
                throw new RepositoryResourceValidationException("The product version was invalid: " + res2Version, res2.getId(), iae);
            }
            if (res1Version.compareTo(res2Version) > 0) {
                return res1;
            }
            return res2;
        }
        if (res1.getType() == ResourceType.TOOL) {
            return res1;
        }
        return this.compareNonProductResourceAppliesTo(res1, res2);
    }

    private RepositoryResource returnNonBetaResourceOrNull(RepositoryResource res1, RepositoryResource res2) {
        if (this.isBeta(res1) && !this.isBeta(res2)) {
            return res2;
        }
        if (!this.isBeta(res1) && this.isBeta(res2)) {
            return res1;
        }
        return null;
    }

    private boolean isBeta(RepositoryResource res) {
        String version;
        String regex;
        if (res.getType() == ResourceType.INSTALL) {
            regex = "[2-9][0-9][0-9][0-9][.].*";
            version = ((ProductResourceWritable)res).getProductVersion();
        } else {
            if (res.getType() == ResourceType.TOOL) {
                return false;
            }
            version = ((ApplicableToProduct)((Object)res)).getAppliesTo();
            regex = ".*productVersion=\"?[2-9][0-9][0-9][0-9][.].*";
        }
        if (version == null) {
            return false;
        }
        boolean matches = version.matches(regex);
        return matches;
    }

    private RepositoryResource compareNonProductResourceAppliesTo(RepositoryResource res1, RepositoryResource res2) {
        String res1AppliesTo = ((ApplicableToProduct)((Object)res1)).getAppliesTo();
        String res2AppliesTo = ((ApplicableToProduct)((Object)res2)).getAppliesTo();
        if (res1AppliesTo == null && res2AppliesTo == null) {
            return this.getNonProductResourceWithHigherVersion(res1, res2);
        }
        if (res1AppliesTo == null || res2AppliesTo == null) {
            return res1;
        }
        MinAndMaxVersion res1MinMax = this.getMinAndMaxAppliesToVersionFromAppliesTo(res1AppliesTo);
        MinAndMaxVersion res2MinMax = this.getMinAndMaxAppliesToVersionFromAppliesTo(res2AppliesTo);
        if (res1MinMax.min.compareTo(res2MinMax.min) > 0) {
            return res1;
        }
        if (res1MinMax.min.compareTo(res2MinMax.min) == 0) {
            if (res1MinMax.max.compareTo(res2MinMax.max) > 0) {
                return res1;
            }
            if (res1MinMax.max.compareTo(res2MinMax.max) < 0) {
                return res2;
            }
            return this.getNonProductResourceWithHigherVersion(res1, res2);
        }
        return res2;
    }

    private RepositoryResource getNonProductResourceWithHigherVersion(RepositoryResource res1, RepositoryResource res2) {
        if (res1.getVersion() == null || res2.getVersion() == null) {
            return res1;
        }
        Version4Digit res1Version = null;
        Version4Digit res2Version = null;
        try {
            res1Version = new Version4Digit(res1.getVersion());
            res2Version = new Version4Digit(res2.getVersion());
        }
        catch (IllegalArgumentException iae) {
            return res1;
        }
        if (res1Version.compareTo(res2Version) > 0) {
            return res1;
        }
        return res2;
    }

    private MinAndMaxVersion getMinAndMaxAppliesToVersionFromAppliesTo(String appliesTo) {
        List<AppliesToFilterInfo> res1Filters = AppliesToProcessor.parseAppliesToHeader(appliesTo);
        Version4Digit highestVersion = null;
        Version4Digit lowestVersion = null;
        for (AppliesToFilterInfo f : res1Filters) {
            Version4Digit vLow;
            Version4Digit vHigh = f.getMaxVersion() == null ? MAX_VERSION : new Version4Digit(f.getMaxVersion().getValue());
            Version4Digit version4Digit = vLow = f.getMinVersion() == null ? MIN_VERSION : new Version4Digit(f.getMinVersion().getValue());
            if (highestVersion == null || vHigh.compareTo(highestVersion) > 0) {
                highestVersion = vHigh;
                lowestVersion = vLow;
                continue;
            }
            if (vHigh.compareTo(highestVersion) != 0 || lowestVersion != null && vLow.compareTo(lowestVersion) <= 0) continue;
            highestVersion = vHigh;
            lowestVersion = vLow;
        }
        return new MinAndMaxVersion(lowestVersion, highestVersion);
    }

    private boolean isVisibleAndWebDisplayable(RepositoryResource resource) {
        if (resource instanceof WebDisplayable) {
            DisplayPolicy displayPolicy = ((WebDisplayable)((Object)resource)).getWebDisplayPolicy();
            return displayPolicy == DisplayPolicy.VISIBLE || displayPolicy == null;
        }
        return false;
    }

    public static class MinAndMaxVersion {
        public Version4Digit min;
        public Version4Digit max;

        public MinAndMaxVersion(Version4Digit minVersion, Version4Digit maxVersion) {
            this.min = minVersion;
            this.max = maxVersion;
        }

        public String toString() {
            return "(min=" + this.min + ", max=" + this.max + ")";
        }
    }
}

