/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.threading.listeners.CompletionListener;
import java.util.Collections;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.condition.Condition;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<Condition, Boolean>,
ConfigurationListener,
RuntimeUpdateListener {
    public static final String SESSION_CACHE_CONFIG_CONDITION = "session.cache.config";
    private final AtomicReference<ServiceRegistration<Condition>> conditionReg = new AtomicReference();
    volatile ServiceTracker<Condition, Boolean> runningConditionTracker;
    volatile BundleContext bc;
    AtomicBoolean doRefreshConfigCondition = new AtomicBoolean(false);
    static final long serialVersionUID = -8968313398496515884L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void start(BundleContext context) throws Exception {
        this.bc = context;
        this.runningConditionTracker = new ServiceTracker(this.bc, Condition.class, (ServiceTrackerCustomizer)this);
        this.runningConditionTracker.open();
        this.refreshConfigCondition();
        this.bc.registerService(new String[]{ConfigurationListener.class.getName(), RuntimeUpdateListener.class.getName()}, (Object)this, null);
    }

    public void stop(BundleContext arg0) throws Exception {
        this.runningConditionTracker.close();
    }

    public Boolean addingService(ServiceReference<Condition> ref) {
        if ("io.openliberty.process.running".equals(ref.getProperty("osgi.condition.id"))) {
            return Boolean.TRUE;
        }
        return null;
    }

    public void modifiedService(ServiceReference<Condition> ref, Boolean present) {
    }

    public void removedService(ServiceReference<Condition> ref, Boolean present) {
    }

    public void configurationEvent(ConfigurationEvent event) {
        if ("com.ibm.ws.session.cache".equals(event.getPid()) && (event.getType() == 1 || event.getType() == 2) && this.runningConditionTracker.getService() == Boolean.TRUE) {
            this.doRefreshConfigCondition.set(true);
        }
    }

    public void notificationCreated(RuntimeUpdateManager updateManager, RuntimeUpdateNotification notification) {
        if ("ConfigUpdatesDelivered".equals(notification.getName())) {
            notification.onCompletion((CompletionListener)new CompletionListener<Boolean>(){
                static final long serialVersionUID = 4235889907979645343L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    this.checkForRefresh();
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    this.checkForRefresh();
                }

                private void checkForRefresh() {
                    if (Activator.this.doRefreshConfigCondition.compareAndSet(true, false)) {
                        Activator.this.refreshConfigCondition();
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.session.store.cache.Activator$1", 1.class, null, (String)"com.ibm.ws.session.store.cache.resources.WASSessionCache");
                }
            });
        }
    }

    void refreshConfigCondition() {
        this.conditionReg.getAndUpdate(reg -> {
            if (reg != null) {
                reg.unregister();
            }
            return this.bc.registerService(Condition.class, (Object)Condition.INSTANCE, FrameworkUtil.asDictionary(Collections.singletonMap("osgi.condition.id", SESSION_CACHE_CONFIG_CONDITION)));
        });
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.session.store.cache.Activator", Activator.class, null, (String)"com.ibm.ws.session.store.cache.resources.WASSessionCache");
    }
}

