/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi.stackjoiner;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

class ReflectionHelper {
    private static final boolean securityEnabled = System.getSecurityManager() != null;

    private ReflectionHelper() {
    }

    static Field getDeclaredField(Class<?> clazz, String fieldName) {
        if (clazz != null) {
            return securityEnabled ? ReflectionHelper.doPrivGetDeclaredField(clazz, fieldName) : ReflectionHelper.doGetDeclaredField(clazz, fieldName);
        }
        return null;
    }

    private static Field doGetDeclaredField(Class<?> clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }

    private static Field doPrivGetDeclaredField(final Class<?> clazz, final String fieldName) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                return ReflectionHelper.doGetDeclaredField(clazz, fieldName);
            }
        });
    }

    static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        if (clazz != null) {
            return securityEnabled ? ReflectionHelper.doPrivGetDeclaredMethod(clazz, methodName, parameterTypes) : ReflectionHelper.doGetDeclaredMethod(clazz, methodName, parameterTypes);
        }
        return null;
    }

    private static Method doGetDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    private static Method doPrivGetDeclaredMethod(final Class<?> clazz, final String methodName, final Class<?> ... parameterTypes) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                return ReflectionHelper.doGetDeclaredMethod(clazz, methodName, parameterTypes);
            }
        });
    }

    static void setAccessible(AccessibleObject accessibleObject, boolean visible) {
        if (securityEnabled) {
            ReflectionHelper.doPrivSetAccessible(accessibleObject, visible);
        } else {
            ReflectionHelper.doSetAccessible(accessibleObject, visible);
        }
    }

    private static void doSetAccessible(AccessibleObject accessibleObject, boolean visible) {
        accessibleObject.setAccessible(visible);
    }

    private static void doPrivSetAccessible(final AccessibleObject accessibleObject, final boolean visible) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ReflectionHelper.doSetAccessible(accessibleObject, visible);
                return null;
            }
        });
    }
}

