/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component
public class LoggingIntrospector
implements Introspector {
    static final long serialVersionUID = 3055470258598051330L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getIntrospectorName() {
        return "LoggingIntrospector";
    }

    public String getIntrospectorDescription() {
        return "Introspects the Logging framework";
    }

    public void introspect(PrintWriter writer) {
        LogManager lm = LogManager.getLogManager();
        try {
            writer.println("System Property: java.util.logging.config.class = " + System.getProperty("java.util.logging.config.class"));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.diagnostics.osgi.LoggingIntrospector", (String)"51", (Object)this, (Object[])new Object[]{writer});
        }
        try {
            writer.println("System Property: com.ibm.ejs.ras.writeSystemStreamsDirectlyToFile = " + System.getProperty("com.ibm.ejs.ras.writeSystemStreamsDirectlyToFile"));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.diagnostics.osgi.LoggingIntrospector", (String)"55", (Object)this, (Object[])new Object[]{writer});
        }
        try {
            writer.println("System Property: java.util.logging.config.file = " + System.getProperty("java.util.logging.config.file"));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.diagnostics.osgi.LoggingIntrospector", (String)"59", (Object)this, (Object[])new Object[]{writer});
        }
        try {
            writer.println("System Property: java.home = " + System.getProperty("java.home"));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.diagnostics.osgi.LoggingIntrospector", (String)"63", (Object)this, (Object[])new Object[]{writer});
        }
        writer.println("");
        try {
            writer.println("LogManager Property: handlers = " + System.getProperty("handlers"));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.diagnostics.osgi.LoggingIntrospector", (String)"70", (Object)this, (Object[])new Object[]{writer});
        }
        try {
            writer.println("LogManager Property: config = " + System.getProperty("config"));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.diagnostics.osgi.LoggingIntrospector", (String)"74", (Object)this, (Object[])new Object[]{writer});
        }
        writer.println("");
        try {
            writer.println("System.out is set to " + System.out);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.diagnostics.osgi.LoggingIntrospector", (String)"81", (Object)this, (Object[])new Object[]{writer});
        }
        try {
            writer.println("System.err is set to " + System.err);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.diagnostics.osgi.LoggingIntrospector", (String)"85", (Object)this, (Object[])new Object[]{writer});
        }
        writer.println("");
        if (lm == null) {
            writer.println("LogManager could not be retrieved. Value is NULL. Logging Introspector will now exit as no further data can be found.");
            return;
        }
        writer.println("logManager.getClass() == " + lm.getClass().getName() + "\n");
        Enumeration<String> en = lm.getLoggerNames();
        while (en.hasMoreElements()) {
            String loggerName = en.nextElement();
            Logger logger = lm.getLogger(loggerName);
            if (logger == null) {
                writer.println("A logger called " + loggerName + " could not be retrieved or does not exist. Skipping... \n");
                continue;
            }
            writer.println("Logger \"" + loggerName + "\" type: " + logger.getClass().getName() + " level: " + logger.getLevel());
            Handler[] handlers = logger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                writer.println("        Handler " + i + " " + handlers[i] + " type: " + handlers[i].getClass().getName() + " level: " + handlers[i].getLevel().getName());
                if (!(handlers[i] instanceof Handler)) continue;
                final Handler h = handlers[i];
                final Class<?> tempClass = h.getClass();
                try {
                    Handler wsHandler = (Handler)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                        static final long serialVersionUID = 599628191894242300L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public Object run() throws Exception {
                            AccessibleObject[] tempObjectFields = tempClass.getDeclaredFields();
                            if (tempObjectFields.length != 0) {
                                AccessibleObject.setAccessible(tempObjectFields, true);
                            }
                            for (int i = 0; i < tempObjectFields.length; ++i) {
                                AccessibleObject f = tempObjectFields[i];
                                if (!((Field)f).getName().contains("Handler")) continue;
                                return ((Field)f).get(h);
                            }
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.LoggingIntrospector$1", 1.class, null, null);
                        }
                    });
                    if (wsHandler == null) continue;
                    writer.println("Handler.class: " + wsHandler.getClass().getName());
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.diagnostics.osgi.LoggingIntrospector", (String)"138", (Object)this, (Object[])new Object[]{writer});
                }
            }
            writer.println("");
        }
        writer.println("Logging Introspector has completed.");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.LoggingIntrospector", LoggingIntrospector.class, null, null);
    }
}

