/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.ClassNotFoundException;
import com.ibm.ws.objectManager.ManagedObjectInputStream;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class LogRecord
implements Serializable {
    private static final Class cclass = LogRecord.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerTransactions");
    public static final int TYPE_USER_DEFINED = 0;
    protected static final int TYPE_ADD = 1;
    protected static final int TYPE_REPLACE = 2;
    protected static final int TYPE_OPTIMISTIC_REPLACE = 3;
    protected static final int TYPE_DELETE = 4;
    protected static final int TYPE_PREPARE = 5;
    protected static final int TYPE_COMMIT = 6;
    protected static final int TYPE_BACKOUT = 7;
    protected static final int TYPE_CHECKPOINT_START = 8;
    protected static final int TYPE_CHECKPOINT_END = 9;
    protected static final int TYPE_CHECKPOINT_TRANSACTION = 10;
    protected static final int TYPE_PADDING = 11;
    public ObjectManagerByteArrayOutputStream[] buffers;
    int bufferCursor = 0;
    int bufferByteCursor = 0;
    protected byte multiPartID = 0;
    private static final byte SimpleSerialVersion = 0;

    protected static LogRecord getUserLogRecord(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        byte[] logRecordBytes;
        String methodName = "getUserLogRecord";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "getUserLogRecord", new Object[]{dataInputStream, objectManagerState});
        }
        try {
            long serializedLogRecordLength = dataInputStream.readLong();
            logRecordBytes = new byte[(int)serializedLogRecordLength];
            dataInputStream.read(logRecordBytes);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(cclass, "getUserLogRecord", exception, "1:94:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(cclass, "getUserLogRecord", new Object[]{exception});
            }
            throw new PermanentIOException((Object)"LogRecord", exception);
        }
        LogRecord logRecord = (LogRecord)LogRecord.deserialize(logRecordBytes, objectManagerState);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "getUserLogRecord", logRecord);
        }
        return logRecord;
    }

    protected int getBytesLeft() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getBytesLeft");
        }
        int totalBytes = -this.bufferByteCursor;
        for (int i = this.bufferCursor; i < this.buffers.length; ++i) {
            totalBytes += this.buffers[i].getCount();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getBytesLeft", "returns totalBytes=" + totalBytes + "(int)");
        }
        return totalBytes;
    }

    protected boolean atStart() {
        boolean atStartOfLogRecord;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "atStart");
        }
        boolean bl = atStartOfLogRecord = this.bufferCursor == 0 && this.bufferByteCursor == 0;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "atStart", "returns atStartOfLogRecord=" + atStartOfLogRecord + "(boolean)");
        }
        return atStartOfLogRecord;
    }

    protected int fillBuffer(byte[] buffer, int offset, int length) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "fillBuffer", new Object[]{buffer, new Integer(offset), new Integer(length)});
        }
        while (length > 0) {
            int lengthToCopy = Math.min(this.buffers[this.bufferCursor].getCount() - this.bufferByteCursor, length);
            System.arraycopy(this.buffers[this.bufferCursor].getBuffer(), this.bufferByteCursor, buffer, offset, lengthToCopy);
            offset += lengthToCopy;
            this.bufferByteCursor += lengthToCopy;
            if ((length -= lengthToCopy) <= 0) continue;
            ++this.bufferCursor;
            this.bufferByteCursor = 0;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "fillBuffer", "returns offset=" + offset + "(int)");
        }
        return offset;
    }

    protected ObjectManagerByteArrayOutputStream[] getBuffers() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getBuffers");
        }
        ObjectManagerByteArrayOutputStream serializedLogRecord = this.serialize(this);
        ObjectManagerByteArrayOutputStream[] buffers = new ObjectManagerByteArrayOutputStream[2];
        buffers[0] = new ObjectManagerByteArrayOutputStream(12);
        buffers[0].writeInt(0);
        buffers[0].writeLong(serializedLogRecord.getCount());
        buffers[1] = serializedLogRecord;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getBuffers", "returns buffers=" + buffers + "(byte[][])");
        }
        return buffers;
    }

    public abstract void performRecovery(ObjectManagerState var1) throws ObjectManagerException;

    protected static long maximumSerializedSize() {
        throw new UnsupportedOperationException();
    }

    protected ObjectManagerByteArrayOutputStream serialize(Serializable serializableObject) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "serialize", new Object[]{serializableObject});
        }
        ObjectManagerByteArrayOutputStream byteArrayOutputStream = new ObjectManagerByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializableObject);
            objectOutputStream.close();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "serialize", exception, "1:303:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "serialize", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "serialize", new Object[]{byteArrayOutputStream});
        }
        return byteArrayOutputStream;
    }

    protected static Object deserialize(byte[] objectBytes, ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "deserialize";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "deserialize", new Object[]{objectBytes, objectManagerState});
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(objectBytes);
        Object object = null;
        try {
            ManagedObjectInputStream managedObjectInputStream = new ManagedObjectInputStream(byteArrayInputStream, objectManagerState);
            object = managedObjectInputStream.readObject();
            managedObjectInputStream.close();
        }
        catch (java.lang.ClassNotFoundException exception) {
            ObjectManager.ffdc.processException(cclass, "deserialize", exception, "1:347:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(cclass, "deserialize", exception);
            }
            throw new ClassNotFoundException(cclass, exception);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(cclass, "deserialize", exception, "1:357:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(cclass, "deserialize", exception);
            }
            throw new PermanentIOException(cclass, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "deserialize", new Object[]{object});
        }
        return object;
    }
}

