/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaas.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaas.common.JAASConfiguration;
import com.ibm.ws.security.jaas.common.JAASLoginContextEntry;
import com.ibm.ws.security.jaas.common.internal.JAASSecurityConfiguration;
import com.ibm.ws.security.jaas.config.JAASLoginConfig;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JAASConfigurationFactory.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JAASConfigurationFactory {
    private static TraceComponent tc = Tr.register(JAASConfigurationFactory.class, (String)"security", (String)"com.ibm.ws.security.jaas.common.internal.resources.JAASCommonMessages");
    public static final String KEY_JAAS_CONFIGURATION = "jaasConfiguration";
    public static final String KEY_JAAS_LOGIN_CONFIG = "JAASLoginConfig";
    private final AtomicServiceReference<JAASConfiguration> jaasConfigurationRef = new AtomicServiceReference("jaasConfiguration");
    private final AtomicServiceReference<JAASLoginConfig> jaasLoginConfigRef = new AtomicServiceReference("JAASLoginConfig");
    private JAASSecurityConfiguration jaasSecurityConfiguration = null;
    private Map<String, List<AppConfigurationEntry>> jaasConfigurationEntriesFromJaasConfig = null;
    static final long serialVersionUID = -6110073176582224681L;

    @Reference(service=JAASLoginConfig.class, name="JAASLoginConfig", cardinality=ReferenceCardinality.MANDATORY)
    public void setJAASLoginConfig(ServiceReference<JAASLoginConfig> ref) {
        this.jaasLoginConfigRef.setReference(ref);
    }

    protected void unsetJAASLoginConfig(ServiceReference<JAASLoginConfig> ref) {
        this.jaasLoginConfigRef.unsetReference(ref);
    }

    @Reference(service=JAASConfiguration.class, name="jaasConfiguration")
    public void setJAASConfiguration(ServiceReference<JAASConfiguration> ref) {
        this.jaasConfigurationRef.setReference(ref);
    }

    protected void unsetJAASConfiguration(ServiceReference<JAASConfiguration> ref) {
        this.jaasConfigurationRef.unsetReference(ref);
    }

    @Activate
    public void activate(ComponentContext cc) {
        this.jaasConfigurationRef.activate(cc);
        this.jaasLoginConfigRef.activate(cc);
        this.installJAASConfigurationFromJAASConfigFile();
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.jaasConfigurationRef.deactivate(cc);
        this.jaasLoginConfigRef.deactivate(cc);
        this.jaasSecurityConfiguration = null;
        this.jaasConfigurationEntriesFromJaasConfig = null;
    }

    public synchronized void installJAASConfiguration(ConcurrentServiceReferenceMap<String, JAASLoginContextEntry> jaasLoginContextEntries) {
        JAASConfiguration jaasConfiguration = (JAASConfiguration)this.jaasConfigurationRef.getServiceWithException();
        jaasConfiguration.setJaasLoginContextEntries(jaasLoginContextEntries);
        Map<String, List<AppConfigurationEntry>> jaasConfigurationEntries = jaasConfiguration.getEntries();
        if (this.jaasSecurityConfiguration == null) {
            this.jaasSecurityConfiguration = new JAASSecurityConfiguration();
            Configuration.setConfiguration(this.jaasSecurityConfiguration);
        }
        if (this.jaasConfigurationEntriesFromJaasConfig != null) {
            this.checkForDuplicateEntries(jaasConfigurationEntries);
        }
        this.jaasSecurityConfiguration.setAppConfigurationEntries(jaasConfigurationEntries);
    }

    protected synchronized void installJAASConfigurationFromJAASConfigFile() {
        JAASLoginConfig jaasLoginConfig = (JAASLoginConfig)this.jaasLoginConfigRef.getService();
        if (jaasLoginConfig != null) {
            this.jaasConfigurationEntriesFromJaasConfig = jaasLoginConfig.getEntries();
            if (this.jaasConfigurationEntriesFromJaasConfig != null) {
                if (this.jaasSecurityConfiguration == null) {
                    this.jaasSecurityConfiguration = new JAASSecurityConfiguration();
                    Configuration.setConfiguration(this.jaasSecurityConfiguration);
                }
                this.jaasSecurityConfiguration.setAppConfigurationEntries(this.jaasConfigurationEntriesFromJaasConfig);
            }
        }
    }

    private void checkForDuplicateEntries(Map<String, List<AppConfigurationEntry>> jaasConfigurationEntries) {
        for (Map.Entry<String, List<AppConfigurationEntry>> entry : jaasConfigurationEntries.entrySet()) {
            String jaasLoginContextEnrty = entry.getKey();
            if (!this.jaasConfigurationEntriesFromJaasConfig.containsKey(jaasLoginContextEnrty)) continue;
            Tr.warning((TraceComponent)tc, (String)"JAAS_DUPLICATE_ENTRY_NAME", (Object[])new Object[]{jaasLoginContextEnrty});
        }
    }

    public JAASSecurityConfiguration getJaasConfiguration() {
        return this.jaasSecurityConfiguration;
    }
}

