/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.deliverydelay;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.deliverydelay.DeliveryDelayableReference;
import com.ibm.ws.sib.msgstore.gbs.GBSTree;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Comparator;

public class DeliveryDelayIndex {
    private static TraceComponent tc = SibTr.register(DeliveryDelayIndex.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private GBSTree tree = null;
    private GBSTree.Iterator iterator = null;
    private int size = 0;

    public DeliveryDelayIndex() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.tree = new GBSTree(2, 10, (Comparator)new DeliveryDelayComparator(), (Comparator)new DeliveryDelayComparator());
        this.iterator = this.tree.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public boolean put(DeliveryDelayableReference deliveryDelayableReference) {
        boolean reply;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"put", (Object)("ObjId=" + deliveryDelayableReference.getID() + " ET=" + deliveryDelayableReference.getDeliveryDelayTime()));
        }
        if (reply = this.tree.insert((Object)deliveryDelayableReference)) {
            ++this.size;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"put", (Object)("reply=" + reply));
        }
        return reply;
    }

    public boolean remove() {
        boolean reply;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove");
        }
        if (reply = this.iterator.remove()) {
            --this.size;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)("reply=" + reply));
        }
        return reply;
    }

    public boolean remove(DeliveryDelayableReference deliveryDelayableReference) {
        boolean reply;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove", (Object)(deliveryDelayableReference == null ? "null" : "ObjId=" + deliveryDelayableReference.getID() + " ET=" + deliveryDelayableReference.getDeliveryDelayTime()));
        }
        if (reply = this.tree.delete((Object)deliveryDelayableReference)) {
            --this.size;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)("reply=" + reply));
        }
        return reply;
    }

    public void resetIterator() {
        this.iterator.reset();
    }

    public int size() {
        return this.size;
    }

    public DeliveryDelayableReference next() {
        return (DeliveryDelayableReference)this.iterator.next();
    }

    private static class DeliveryDelayComparator
    implements Comparator {
        private DeliveryDelayComparator() {
        }

        public int compare(Object o1, Object o2) {
            long time2;
            DeliveryDelayableReference ref1 = (DeliveryDelayableReference)o1;
            DeliveryDelayableReference ref2 = (DeliveryDelayableReference)o2;
            long time1 = ref1.getDeliveryDelayTime();
            if (time1 == (time2 = ref2.getDeliveryDelayTime())) {
                long id2;
                long id1 = ref1.getID();
                if (id1 == (id2 = ref2.getID())) {
                    return 0;
                }
                if (id1 < id2) {
                    return -1;
                }
                return 1;
            }
            if (time1 < time2) {
                return -1;
            }
            return 1;
        }
    }
}

