/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.osgi.internal.url;

import com.ibm.websphere.ras.annotation.Trivial;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FilterZipFileInputStream
extends InputStream {
    private final ZipFile zipFile;
    private final Enumeration<? extends ZipEntry> entries;
    private final String entryPrefix;
    private final ZipOutputStream out = new ZipOutputStream(new InternalBufferOutputStream());
    byte[] buffer = new byte[8192];
    int pos;
    int max;
    private InputStream entryInput;
    private final byte[] entryInputBuffer = new byte[8192];

    public FilterZipFileInputStream(File zipFile, String entryPath) throws ZipException, IOException {
        if (zipFile == null) {
            throw new IllegalArgumentException("FilterZipFileInputStream zipFile cannot be null.");
        }
        this.zipFile = new ZipFile(zipFile);
        this.entryPrefix = entryPath;
        if (this.entryPrefix == null || this.entryPrefix.length() == 0 || this.entryPrefix.endsWith("/")) {
            this.entries = this.zipFile.entries();
        } else {
            final ZipEntry targetEntry = this.zipFile.getEntry(this.entryPrefix);
            this.entries = new Enumeration<ZipEntry>(){
                boolean readEntry = false;
                ZipEntry tEntry = targetEntry;

                @Override
                public boolean hasMoreElements() {
                    return !this.readEntry;
                }

                @Override
                public ZipEntry nextElement() {
                    if (this.readEntry) {
                        throw new NoSuchElementException();
                    }
                    this.readEntry = true;
                    return this.tEntry;
                }
            };
        }
    }

    @Override
    @Trivial
    public int read() throws IOException {
        if (this.pos == this.max && !this.refill()) {
            return -1;
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        if (this.entryInput != null) {
            this.entryInput.close();
        }
        this.zipFile.close();
    }

    @Trivial
    private boolean refill() throws IOException {
        this.max = 0;
        this.pos = 0;
        do {
            ZipEntry entry;
            String entryName;
            block6: {
                if (this.entryInput != null) {
                    do {
                        int read;
                        if ((read = this.entryInput.read(this.entryInputBuffer, 0, this.entryInputBuffer.length)) == -1) {
                            this.entryInput.close();
                            this.entryInput = null;
                            this.out.closeEntry();
                            if (this.max != 0) {
                                return true;
                            }
                            break block6;
                        }
                        this.out.write(this.entryInputBuffer, 0, read);
                    } while (this.max == 0);
                    return true;
                }
            }
            do {
                if (this.entries.hasMoreElements()) continue;
                this.out.close();
                return this.max != 0;
            } while (!(entryName = (entry = this.entries.nextElement()).getName()).startsWith(this.entryPrefix) || entry.isDirectory());
            this.entryInput = this.zipFile.getInputStream(entry);
            this.out.putNextEntry(new ZipEntry(entryName.substring(this.entryPrefix.length())));
        } while (this.max == 0);
        return true;
    }

    private class InternalBufferOutputStream
    extends OutputStream {
        private InternalBufferOutputStream() {
        }

        @Override
        @Trivial
        public void write(int b) throws IOException {
            if (FilterZipFileInputStream.this.max == FilterZipFileInputStream.this.buffer.length) {
                FilterZipFileInputStream.this.buffer = Arrays.copyOf(FilterZipFileInputStream.this.buffer, FilterZipFileInputStream.this.max + FilterZipFileInputStream.this.max);
            }
            FilterZipFileInputStream.this.buffer[FilterZipFileInputStream.this.max++] = (byte)b;
        }
    }
}

