/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.monitor.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryAccessor;
import io.openliberty.microprofile.telemetry.internal.monitor.internal.MonitorCounter;
import io.openliberty.microprofile.telemetry.internal.monitor.internal.MonitorGauge;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.api.metrics.ObservableLongCounter;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MonitorMetrics {
    private static final TraceComponent tc = Tr.register(MonitorMetrics.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    public static final String SCOPE = "io.openliberty.monitor.metrics";
    public static final String OPEN_LIBERTY_NAMESPACE_PREFIX = "io.openliberty.";
    protected String objectName;
    protected String mbeanStatsName;
    protected MBeanServer mbs = AccessController.doPrivileged(() -> ManagementFactory.getPlatformMBeanServer());
    protected Set<AutoCloseable> acInstrumentSet;
    static final long serialVersionUID = 4148428707358043777L;

    public MonitorMetrics(String objectName) {
        this.objectName = objectName;
        this.acInstrumentSet = new HashSet<AutoCloseable>();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void createMetrics(String[][] data) {
        OpenTelemetry otelInstance = OpenTelemetryAccessor.getOpenTelemetryInfo().getOpenTelemetry();
        if (otelInstance == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)String.format("Unable to resolve an OpenTelemetry instance when regstering metrics for Mbean[%s]", new Object[0]), (Object[])new Object[]{this.objectName});
            }
            return;
        }
        Meter otelMeter = otelInstance.getMeterProvider().get(SCOPE);
        for (String[] metricData : data) {
            ObservableLongCounter olc;
            MonitorCounter mc;
            String metricName = OPEN_LIBERTY_NAMESPACE_PREFIX + metricData[0];
            String metricTagName = metricData[6];
            AttributesBuilder attributesBuilder = Attributes.builder();
            if (metricTagName != null) {
                attributesBuilder.put(OPEN_LIBERTY_NAMESPACE_PREFIX + metricTagName, this.getMBeanStatsString());
            }
            String metricType = metricData[2];
            String description = Tr.formatMessage((TraceComponent)tc, (String)metricData[1], (Object[])new Object[0]);
            String unit = metricData[3];
            if ("LONGCOUNTER".equalsIgnoreCase(metricType)) {
                mc = metricData[5] == null ? new MonitorCounter(this.mbs, this.objectName, metricData[4]) : new MonitorCounter(this.mbs, this.objectName, metricData[4], metricData[5]);
                LongCounterBuilder lcb = otelMeter.counterBuilder(metricName).setDescription(description);
                if (unit != null) {
                    lcb.setUnit(unit);
                }
                olc = lcb.buildWithCallback(measurment -> measurment.record(mc.getCount(), attributesBuilder.build()));
                this.acInstrumentSet.add((AutoCloseable)olc);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Registered " + olc.toString()), (Object[])new Object[0]);
                continue;
            }
            if ("LONGUPDOWNCOUNTER".equalsIgnoreCase(metricType)) {
                mc = metricData[5] == null ? new MonitorCounter(this.mbs, this.objectName, metricData[4]) : new MonitorCounter(this.mbs, this.objectName, metricData[4], metricData[5]);
                LongUpDownCounterBuilder ludcb = otelMeter.upDownCounterBuilder(metricName).setDescription(description);
                if (unit != null) {
                    ludcb.setUnit(unit);
                }
                olc = ludcb.buildWithCallback(measurment -> measurment.record(mc.getCount(), attributesBuilder.build()));
                this.acInstrumentSet.add((AutoCloseable)olc);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Registered " + olc.toString()), (Object[])new Object[0]);
                continue;
            }
            if ("LONGGAUGE".equalsIgnoreCase(metricType)) {
                MonitorGauge mg = metricData[5] == null ? new MonitorGauge(this.mbs, this.objectName, metricData[4]) : new MonitorGauge(this.mbs, this.objectName, metricData[4], metricData[5]);
                DoubleGaugeBuilder dgb = otelMeter.gaugeBuilder(metricName).setDescription(description);
                if (unit != null) {
                    dgb.setUnit(unit);
                }
                ObservableDoubleGauge odg = dgb.buildWithCallback(measurment -> measurment.record(((Number)mg.getValue()).doubleValue(), attributesBuilder.build()));
                this.acInstrumentSet.add((AutoCloseable)odg);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Registered " + odg.toString()), (Object[])new Object[0]);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Failed to register " + metricName + " because of invalid type " + metricType), (Object[])new Object[0]);
        }
    }

    protected String getMBeanStatsString() {
        if (this.mbeanStatsName == null) {
            String serviceName = null;
            String serviceURL = null;
            String portName = null;
            String mbeanObjName = null;
            StringBuffer sb = new StringBuffer();
            for (String subString : this.objectName.split(",")) {
                if ((subString = subString.trim()).contains("service=")) {
                    serviceName = this.getMBeanStatsServiceName(subString);
                    serviceURL = this.getMBeanStatsServiceURL(subString);
                    continue;
                }
                if (subString.contains("port=")) {
                    portName = this.getMBeanStatsPortName(subString);
                    continue;
                }
                if (!subString.contains("name=")) continue;
                mbeanObjName = this.getMBeanStatsName(subString);
                break;
            }
            if (serviceURL != null && serviceName != null && portName != null) {
                sb.append(serviceURL);
                sb.append(".");
                sb.append(serviceName);
                sb.append(".");
                sb.append(portName);
            } else if (mbeanObjName != null) {
                sb.append(mbeanObjName);
            } else {
                sb.append("unknown");
            }
            this.mbeanStatsName = sb.toString();
        }
        return this.mbeanStatsName;
    }

    private String getMBeanStatsName(String nameStr) {
        String mbeanName = nameStr.split("=")[1];
        return mbeanName;
    }

    private String getMBeanStatsServiceName(String serviceStr) {
        serviceStr = serviceStr.split("=")[1];
        serviceStr = serviceStr.replaceAll("\"", "");
        String serviceName = serviceStr.substring(serviceStr.indexOf("}") + 1);
        return serviceName;
    }

    private String getMBeanStatsServiceURL(String serviceStr) {
        serviceStr = serviceStr.split("=")[1];
        serviceStr = serviceStr.replaceAll("\"", "");
        String serviceURL = serviceStr.substring(serviceStr.indexOf("{") + 1, serviceStr.indexOf("}"));
        serviceURL = serviceURL.replace("http://", "").replace("https://", "").replace("/", ".");
        return serviceURL;
    }

    private String getMBeanStatsPortName(String portStr) {
        portStr = portStr.split("=")[1];
        String portName = portStr.replaceAll("\"", "");
        return portName;
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterMetrics() {
        for (AutoCloseable ac : this.acInstrumentSet) {
            try {
                ac.close();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.telemetry.internal.monitor.internal.MonitorMetrics", (String)"243", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)String.format("Failed to close %s  due to exception encountered:\n %s", ac, e), (Object[])new Object[0]);
            }
        }
    }
}

