/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.io.async.AsyncProperties;
import com.ibm.io.async.IAbstractAsyncFuture;
import com.ibm.io.async.TimeSlot;
import com.ibm.io.async.TimerCallback;
import com.ibm.io.async.TimerLinkedList;
import com.ibm.io.async.TimerWorkItem;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;

public final class Timer
extends Thread {
    public static final long TIMESLOT_PRUNING_THRESHOLD = 4096L;
    public static final long TIMEOUT_CHECKING_THRESHOLD = 1000L;
    private TimeSlot firstSlot = null;
    private TimeSlot lastSlot = null;
    public static final long timeoutResolution = -1024L;
    public static final long timeoutRoundup = 1024L;
    private final TimerLinkedList requestQueue1 = new TimerLinkedList();
    private final TimerLinkedList requestQueue2 = new TimerLinkedList();
    private int queueToUse = 1;
    private static int numQueues = AsyncProperties.numTimerQueues;
    private static final TraceComponent tc;

    public Timer() {
        if (AsyncProperties.disableTimeouts) {
            return;
        }
        this.setName("AIO Timer Thread 1");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerWorkItem createTimeoutRequest(long timeoutTime, TimerCallback _callback, IAbstractAsyncFuture _future) {
        TimerWorkItem wi = new TimerWorkItem(timeoutTime, _callback, _future, _future.getReuseCount());
        _future.setTimeoutWorkItem(wi);
        if (this.queueToUse == 1 || numQueues == 1) {
            TimerLinkedList timerLinkedList = this.requestQueue1;
            synchronized (timerLinkedList) {
                this.requestQueue1.add(wi);
            }
        }
        TimerLinkedList timerLinkedList = this.requestQueue2;
        synchronized (timerLinkedList) {
            this.requestQueue2.add(wi);
        }
        return wi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int numItemsToWorkOn = 0;
        long lastPruneTime = 0L;
        long lastCheckTime = 0L;
        int listSize = 1;
        int i = 0;
        int sleepTime = AsyncProperties.timerSleepTime;
        int batchLimitSize = AsyncProperties.timerBatchSize;
        boolean sleepAlways = AsyncProperties.timerSleepAlways;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Timeout thread running with the following parameters", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("numQueues:      " + numQueues), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sleepAlways:    " + sleepAlways), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sleepTime:      " + sleepTime), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("batchLimitSize: " + batchLimitSize), (Object[])new Object[0]);
        }
        TimerWorkItem[] workItems = new TimerWorkItem[batchLimitSize];
        long currentTime = CHFWBundle.getApproxTime();
        while (true) {
            TimerLinkedList timerLinkedList;
            if (listSize == 0 || sleepAlways) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            numItemsToWorkOn = 0;
            if (this.queueToUse == 1 || numQueues == 1) {
                this.queueToUse = 2;
                timerLinkedList = this.requestQueue1;
                synchronized (timerLinkedList) {
                    listSize = this.requestQueue1.size();
                    if (listSize != 0) {
                        for (i = 0; i < listSize && numItemsToWorkOn < batchLimitSize; ++i) {
                            workItems[numItemsToWorkOn] = (TimerWorkItem)this.requestQueue1.removeFirst();
                            if (workItems[numItemsToWorkOn].state == 2L) continue;
                            ++numItemsToWorkOn;
                        }
                    }
                }
            }
            this.queueToUse = 1;
            timerLinkedList = this.requestQueue2;
            synchronized (timerLinkedList) {
                listSize = this.requestQueue2.size();
                if (listSize != 0) {
                    for (i = 0; i < listSize && numItemsToWorkOn < batchLimitSize; ++i) {
                        workItems[numItemsToWorkOn] = (TimerWorkItem)this.requestQueue2.removeFirst();
                        if (workItems[numItemsToWorkOn].state == 2L) continue;
                        ++numItemsToWorkOn;
                    }
                }
            }
            for (i = 0; i < numItemsToWorkOn; ++i) {
                if (workItems[i].state == 2L) continue;
                this.insertWorkItem(workItems[i], currentTime);
            }
            currentTime = CHFWBundle.getApproxTime();
            if (currentTime - lastCheckTime > 1000L) {
                this.checkForTimeouts(currentTime);
                lastCheckTime = currentTime;
            }
            if (currentTime - lastPruneTime <= 4096L) continue;
            this.timeSlotPruning(currentTime);
            lastPruneTime = currentTime;
        }
    }

    public void timeSlotPruning(long curTime) {
        TimeSlot slotEntry = this.firstSlot;
        TimeSlot nextSlot = null;
        int endIndex = 0;
        while (slotEntry != null) {
            nextSlot = slotEntry.nextEntry;
            if (curTime - slotEntry.mostRecentlyAccessedTime > 4096L) {
                int i;
                for (i = endIndex = slotEntry.lastEntryIndex; i >= 0 && slotEntry.entries[i].state != 1L; --i) {
                }
                if (i < 0) {
                    this.removeSlot(slotEntry);
                }
            }
            slotEntry = nextSlot;
        }
    }

    public void insertWorkItem(TimerWorkItem work, long curTime) {
        long insertTime = work.timeoutTime;
        TimeSlot nextSlot = this.firstSlot;
        while (nextSlot != null) {
            if (insertTime == nextSlot.timeoutTime && nextSlot.lastEntryIndex != 299) {
                nextSlot.addEntry(work, curTime);
                break;
            }
            if (insertTime < nextSlot.timeoutTime) {
                nextSlot = this.insertSlot(insertTime, nextSlot);
                nextSlot.addEntry(work, curTime);
                break;
            }
            nextSlot = nextSlot.nextEntry;
        }
        if (nextSlot == null) {
            nextSlot = this.insertSlotAtEnd(insertTime);
            nextSlot.addEntry(work, curTime);
        }
    }

    public TimeSlot insertSlot(long newSlotTimeout, TimeSlot slot) {
        TimeSlot retSlot = new TimeSlot(newSlotTimeout);
        retSlot.nextEntry = slot;
        retSlot.prevEntry = slot.prevEntry;
        if (retSlot.prevEntry != null) {
            retSlot.prevEntry.nextEntry = retSlot;
        } else {
            this.firstSlot = retSlot;
        }
        slot.prevEntry = retSlot;
        return retSlot;
    }

    public TimeSlot insertSlotAtEnd(long newSlotTimeout) {
        TimeSlot retSlot = new TimeSlot(newSlotTimeout);
        if (this.lastSlot == null) {
            this.lastSlot = retSlot;
            this.firstSlot = retSlot;
        } else {
            retSlot.prevEntry = this.lastSlot;
            this.lastSlot.nextEntry = retSlot;
            this.lastSlot = retSlot;
        }
        return retSlot;
    }

    public void removeSlot(TimeSlot oldSlot) {
        if (oldSlot.nextEntry != null) {
            oldSlot.nextEntry.prevEntry = oldSlot.prevEntry;
        } else {
            this.lastSlot = oldSlot.prevEntry;
        }
        if (oldSlot.prevEntry != null) {
            oldSlot.prevEntry.nextEntry = oldSlot.nextEntry;
        } else {
            this.firstSlot = oldSlot.nextEntry;
        }
    }

    public void checkForTimeouts(long checkTime) {
        TimeSlot nextSlot = this.firstSlot;
        TimerWorkItem entry = null;
        TimeSlot oldSlot = null;
        while (nextSlot != null && checkTime >= nextSlot.timeoutTime) {
            int endIndex = nextSlot.lastEntryIndex;
            for (int i = 0; i <= endIndex; ++i) {
                entry = nextSlot.entries[i];
                if (entry.state != 1L) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found a timeout, calling timerTriggered", (Object[])new Object[0]);
                }
                entry.state = 2L;
                entry.callback.timerTriggered(entry);
            }
            oldSlot = nextSlot;
            this.removeSlot(oldSlot);
            nextSlot = nextSlot.nextEntry;
        }
    }

    static {
        if (numQueues > 2) {
            numQueues = 2;
        }
        tc = Tr.register(Timer.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    }
}

