/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.locks;

import com.ibm.asyncutil.locks.AsyncSemaphore;
import com.ibm.asyncutil.util.StageSupport;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class FairAsyncSemaphore
implements AsyncSemaphore {
    private static final long COMPLETED = Long.MIN_VALUE;
    public static final long MIN_PERMITS = -9223372036854775807L;
    public static final long MAX_PERMITS = 0x7FFFFFFFFFFFFFFEL;
    private static final ThreadLocal<ArrayList<CompletableFuture<Void>>> TRAMPOLINE_FUTURES = ThreadLocal.withInitial(ArrayList::new);
    private static final AtomicReferenceFieldUpdater<FairAsyncSemaphore, Node> HEAD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FairAsyncSemaphore.class, Node.class, "head");
    private static final AtomicReferenceFieldUpdater<FairAsyncSemaphore, Node> TAIL_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FairAsyncSemaphore.class, Node.class, "tail");
    private static final Node NULL_PREDECESSOR;
    private volatile Node head;
    private volatile Node tail;

    public FairAsyncSemaphore(long initialPermits) {
        if (initialPermits < -9223372036854775807L || initialPermits > 0x7FFFFFFFFFFFFFFEL) {
            throw new IllegalArgumentException(String.format("initial permits must be within [%d, %d], given %d", -9223372036854775807L, 0x7FFFFFFFFFFFFFFEL, initialPermits));
        }
        Node h = new Node(NULL_PREDECESSOR, initialPermits);
        if (initialPermits < 0L) {
            Node t = new Node(h);
            h.lazySetNext(t);
            this.tail = t;
        } else {
            this.tail = h;
        }
        this.head = h;
    }

    private static void checkPermitsBounds(long permits) {
        if (permits < 0L || permits > 0x7FFFFFFFFFFFFFFEL) {
            throw new IllegalArgumentException(String.format("permits must be within [%d, %d], given %d", 0L, 0x7FFFFFFFFFFFFFFEL, permits));
        }
    }

    private Node successorSpin(Node n) {
        Node next;
        assert (n.getPermits() < 0L) : "Only reserved nodes can have successors";
        while ((next = n.getNext()) == null) {
        }
        return next;
    }

    private void updateHead(Node expected, Node update) {
        HEAD_UPDATER.compareAndSet(this, expected, update);
    }

    private void updateTail(Node expected, Node update) {
        TAIL_UPDATER.compareAndSet(this, expected, update);
    }

    @Override
    public final CompletionStage<Void> acquire(long permits) {
        long diff;
        Node t;
        FairAsyncSemaphore.checkPermitsBounds(permits);
        Node node = t = this.tail;
        while (true) {
            long nodePermits;
            if ((nodePermits = node.getPermits()) < 0L) {
                node = this.successorSpin(node);
                continue;
            }
            if (permits == 0L && nodePermits == 0L) {
                Node prev = node.getPrevious();
                return prev == null ? StageSupport.voidStage() : prev.getFuture();
            }
            diff = nodePermits - permits;
            if (node.casValue(nodePermits, diff)) break;
        }
        if (diff < 0L) {
            Node newNode = new Node(node);
            node.setNext(newNode);
            this.updateTail(t, newNode);
            return node.getFuture();
        }
        return StageSupport.voidStage();
    }

    @Override
    public final void release(long permits) {
        Node h;
        FairAsyncSemaphore.checkPermitsBounds(permits);
        ArrayList<CompletableFuture<Void>> toComplete = null;
        boolean threadLeader = false;
        Node node = h = this.head;
        while (true) {
            long nodePermits;
            if ((nodePermits = node.getPermits()) < 0L) {
                if (nodePermits == Long.MIN_VALUE) {
                    node = this.successorSpin(node);
                    continue;
                }
                long sum = nodePermits + permits;
                if (sum < 0L) {
                    if (!node.casValue(nodePermits, sum)) continue;
                } else {
                    if (!node.casValue(nodePermits, Long.MIN_VALUE)) continue;
                    node.setPrev(null);
                    if (toComplete == null) {
                        assert (!threadLeader);
                        toComplete = TRAMPOLINE_FUTURES.get();
                        threadLeader = toComplete.isEmpty();
                    }
                    toComplete.add(node.getFuture());
                    if (sum != 0L) {
                        permits = sum;
                        node = this.successorSpin(node);
                        continue;
                    }
                }
                break;
            }
            if (0x7FFFFFFFFFFFFFFEL - permits < nodePermits) {
                throw new IllegalStateException(String.format("Exceeded maximum allowed semaphore permits: %d + %d > %d", nodePermits, permits, 0x7FFFFFFFFFFFFFFEL));
            }
            if (node.casValue(nodePermits, nodePermits + permits)) break;
        }
        if (node != h) {
            this.updateHead(h, node);
        }
        if (threadLeader) {
            if (toComplete == null) {
                throw new AssertionError();
            }
            for (int i = 0; i < toComplete.size(); ++i) {
                toComplete.get(i).complete(null);
            }
            TRAMPOLINE_FUTURES.remove();
        }
    }

    @Override
    public final boolean tryAcquire(long permits) {
        Node h;
        FairAsyncSemaphore.checkPermitsBounds(permits);
        Node node = h = this.head;
        while (true) {
            long diff;
            long nodePermits;
            if ((nodePermits = node.getPermits()) == Long.MIN_VALUE) {
                node = this.successorSpin(node);
                continue;
            }
            if (nodePermits < 0L || (diff = nodePermits - permits) < 0L) {
                return false;
            }
            if (node.casValue(nodePermits, diff)) break;
        }
        if (h != node) {
            this.updateHead(h, node);
        }
        if (permits == 0L) {
            Node prev = node.getPrevious();
            return prev == null || prev.getPermits() == Long.MIN_VALUE;
        }
        return true;
    }

    @Override
    public final long drainPermits() {
        long nodePermits;
        Node h = this.head;
        do {
            if ((nodePermits = h.getPermits()) > 0L) continue;
            return 0L;
        } while (!h.casValue(nodePermits, 0L));
        return nodePermits;
    }

    @Override
    public final long getAvailablePermits() {
        long sum = 0L;
        for (Node n = this.head; n != null; n = n.getNext()) {
            long permits = n.getPermits();
            if (permits == Long.MIN_VALUE) continue;
            sum = Math.addExact(sum, permits);
        }
        return sum;
    }

    @Override
    public final int getQueueLength() {
        int count = 0;
        for (Node n = this.head; n != null; n = n.getNext()) {
            long permits = n.getPermits();
            if (permits >= 0L || permits == Long.MIN_VALUE) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        Node h = this.head;
        Node t = this.tail;
        int count = 0;
        long sum = 0L;
        for (Node n = h; n != null; n = n.getNext()) {
            long permits = n.getPermits();
            if (permits != Long.MIN_VALUE) {
                sum = Math.addExact(sum, permits);
            }
            ++count;
        }
        return "FairAsyncSemaphore [permits=" + sum + ", nodes=" + count + ", head=" + h + ", tail=" + t + "]";
    }

    static {
        Node n = new Node(null, Long.MIN_VALUE);
        n.getFuture().complete(null);
        NULL_PREDECESSOR = n;
    }

    private static final class Node
    extends AtomicLong {
        private static final AtomicReferenceFieldUpdater<Node, Node> NEXT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
        private final CompletableFuture<Void> future = new CompletableFuture();
        private volatile Node next;
        private Node prev;

        Node(Node prev) {
            this.prev = prev;
        }

        Node(Node prev, long initialValue) {
            this.prev = prev;
            this.lazySet(initialValue);
        }

        long getPermits() {
            return this.get();
        }

        boolean casValue(long expected, long update) {
            return this.compareAndSet(expected, update);
        }

        CompletableFuture<Void> getFuture() {
            return this.future;
        }

        void lazySetNext(Node n) {
            NEXT_UPDATER.lazySet(this, n);
        }

        void setNext(Node n) {
            this.next = n;
        }

        Node getNext() {
            return this.next;
        }

        void setPrev(Node n) {
            this.prev = n;
        }

        Node getPrevious() {
            return this.prev;
        }

        @Override
        public String toString() {
            return "Node [" + this.getPermits() + "]";
        }
    }
}

