/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.util.StringTokenizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class DirUtils {
    private static final TraceComponent tc = Tr.register(DirUtils.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    static final long serialVersionUID = 2504784336073631593L;

    @ManualTrace
    public static String createDirectoryPath(String source) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDirectoryPath", (Object[])new Object[]{source});
        }
        String directoryPath = null;
        if (source != null) {
            directoryPath = "";
            StringTokenizer tokenizer = new StringTokenizer(source, "\\/");
            while (tokenizer.hasMoreTokens()) {
                String pathChunk = tokenizer.nextToken();
                directoryPath = directoryPath + pathChunk;
                if (!tokenizer.hasMoreTokens()) continue;
                directoryPath = directoryPath + File.separator;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDirectoryPath", (Object)directoryPath);
        }
        return directoryPath;
    }
}

