/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config14.converters;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.config12.converters.ConstructorFunction;
import com.ibm.ws.microprofile.config12.converters.MethodFunction;
import com.ibm.ws.microprofile.config13.converters.Config13ImplicitConverter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.function.Function;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Config14ImplicitConverter
extends Config13ImplicitConverter {
    private static final TraceComponent tc = Tr.register(Config14ImplicitConverter.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config14.resources.Config14");
    static final long serialVersionUID = -6570032495611298789L;

    @Trivial
    public Config14ImplicitConverter(Class<?> converterType) {
        super(converterType);
    }

    @Trivial
    protected <X> Function<String, X> getImplicitFunction(Class<X> converterType) {
        Function implicitFunction = null;
        implicitFunction = MethodFunction.getOfMethod(converterType);
        if (implicitFunction != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Automatic converter for " + converterType + " using \"of\""), (Object[])new Object[0]);
        }
        if (implicitFunction == null && (implicitFunction = MethodFunction.getValueOfFunction(converterType)) != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Automatic converter for " + converterType + " using \"valueOf\""), (Object[])new Object[0]);
        }
        if (implicitFunction == null && (implicitFunction = MethodFunction.getParseFunction(converterType)) != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Automatic converter for " + converterType + " using \"parse\""), (Object[])new Object[0]);
        }
        if (implicitFunction == null && (implicitFunction = ConstructorFunction.getConstructorFunction(converterType)) != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Automatic converter for " + converterType + " using \"constructor\""), (Object[])new Object[0]);
        }
        if (implicitFunction == null) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"implicit.string.constructor.method.not.found.CWMCG0017E", (Object[])new Object[]{converterType}));
        }
        return implicitFunction;
    }
}

