/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.sequencing;

import java.util.Map;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatasourceLogin;

public class GeneratedValueMetadata
extends ORMetadata {
    private String m_strategy;
    private String m_generator;

    public GeneratedValueMetadata() {
    }

    public GeneratedValueMetadata(MetadataAnnotation generatedValue, MetadataAccessor accessor) {
        super(generatedValue, accessor);
        this.m_generator = generatedValue.getAttributeString("generator");
        this.m_strategy = generatedValue.getAttributeString("strategy");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof GeneratedValueMetadata) {
            GeneratedValueMetadata generatedValue = (GeneratedValueMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_generator, generatedValue.getGenerator())) {
                return false;
            }
            return this.valuesMatch(this.m_strategy, generatedValue.getStrategy());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_strategy != null ? this.m_strategy.hashCode() : 0);
        result = 31 * result + (this.m_generator != null ? this.m_generator.hashCode() : 0);
        return result;
    }

    public String getGenerator() {
        return this.m_generator;
    }

    public String getStrategy() {
        return this.m_strategy;
    }

    public void process(MetadataDescriptor descriptor, Map<String, Sequence> sequences, DatasourceLogin login) {
        Sequence sequence;
        if (this.m_generator == null) {
            this.m_generator = "";
        }
        if ((sequence = sequences.get(this.m_generator)) == null) {
            if (this.m_strategy == null || this.m_strategy.equals("AUTO")) {
                MetadataField mf;
                MetadataField metadataField = mf = this.getAccessibleObject() != null && this.getAccessibleObject() instanceof MetadataField ? (MetadataField)this.getAccessibleObject() : null;
                if (mf != null && "java.util.UUID".equals(mf.getType())) {
                    if (this.m_generator.isEmpty()) {
                        sequence = sequences.get("SEQ_GEN_UUID");
                    } else {
                        sequence = (Sequence)sequences.get("SEQ_GEN_UUID").clone();
                        sequence.setName(this.m_generator);
                    }
                } else if (sequences.containsKey("SEQ_GEN")) {
                    login.setDefaultSequence(sequences.get("SEQ_GEN"));
                }
            } else if (this.m_strategy.equals("TABLE")) {
                if (this.m_generator.isEmpty()) {
                    sequence = sequences.get("SEQ_GEN_TABLE");
                } else {
                    sequence = (Sequence)sequences.get("SEQ_GEN_TABLE").clone();
                    sequence.setName(this.m_generator);
                }
            } else if (this.m_strategy.equals("SEQUENCE")) {
                if (this.m_generator.isEmpty()) {
                    sequence = sequences.get("SEQ_GEN_SEQUENCE");
                } else {
                    sequence = (Sequence)sequences.get("SEQ_GEN_SEQUENCE").clone();
                    sequence.setName(this.m_generator);
                }
            } else if (this.m_strategy.equals("IDENTITY")) {
                if (this.m_generator.isEmpty()) {
                    sequence = sequences.get("SEQ_GEN_IDENTITY");
                } else {
                    sequence = (Sequence)sequences.get("SEQ_GEN_IDENTITY").clone();
                    sequence.setName(this.m_generator);
                }
            } else if (this.m_strategy.equals("UUID")) {
                if (this.m_generator.isEmpty()) {
                    sequence = sequences.get("SEQ_GEN_UUID");
                } else {
                    sequence = (Sequence)sequences.get("SEQ_GEN_UUID").clone();
                    sequence.setName(this.m_generator);
                }
            }
        }
        if (sequence != null) {
            descriptor.setSequenceNumberName(sequence.getName());
            login.addSequence(sequence);
        } else {
            String seqName = this.m_generator.isEmpty() ? (sequences.containsKey("SEQ_GEN") ? sequences.get("SEQ_GEN").getName() : "SEQ_GEN") : this.m_generator;
            descriptor.setSequenceNumberName(seqName);
        }
    }

    public void setGenerator(String generator) {
        this.m_generator = generator;
    }

    public void setStrategy(String strategy) {
        this.m_strategy = strategy;
    }
}

