/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.pipeline.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferUtils;
import com.ibm.wsspi.http.channel.error.HttpError;
import com.ibm.wsspi.http.channel.error.HttpErrorPageProvider;
import com.ibm.wsspi.http.channel.error.HttpErrorPageService;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.TooLongHttpHeaderException;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.ReferenceCountUtil;
import io.openliberty.http.netty.timeout.exception.TimeoutException;
import java.net.InetSocketAddress;
import java.util.Objects;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HttpDispatcherHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final TraceComponent tc = Tr.register(HttpDispatcherHandler.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    HttpChannelConfig config;
    private ChannelHandlerContext context;
    private final DefaultFullHttpResponse errorResponse;
    private static final String MAX_STREAMS_REFUSED_MESSAGE = "too many client-initiated streams have been refused; closing the connection";
    static final long serialVersionUID = 4656957290014952342L;

    public HttpDispatcherHandler(HttpChannelConfig config) {
        super(false);
        Objects.requireNonNull(config);
        this.config = config;
        this.errorResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.context = ctx;
        this.context.channel().attr(NettyHttpConstants.NUMBER_OF_HTTP_REQUESTS).set((Object)0);
        this.context.channel().attr(NettyHttpConstants.STREAMS_REFUSED).set((Object)0);
    }

    public void processMessageDirectly(FullHttpRequest request) throws Exception {
        this.channelRead0(this.context, request);
    }

    protected void channelRead0(final ChannelHandlerContext context, FullHttpRequest request) throws Exception {
        if (request.decoderResult().isFinished() && request.decoderResult().isSuccess()) {
            final FullHttpRequest msg = request;
            HttpDispatcher.getExecutorService().execute(new Runnable(){
                static final long serialVersionUID = 1102158348806569354L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    try {
                        HttpDispatcherHandler.this.newRequest(context, msg);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.http.netty.pipeline.inbound.HttpDispatcherHandler$1", (String)"95", (Object)this, (Object[])new Object[0]);
                        try {
                            void t;
                            HttpDispatcherHandler.this.exceptionCaught(context, (Throwable)t);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.http.netty.pipeline.inbound.HttpDispatcherHandler$1", (String)"98", (Object)this, (Object[])new Object[0]);
                            context.close();
                        }
                    }
                    finally {
                        ReferenceCountUtil.release((Object)msg);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.pipeline.inbound.HttpDispatcherHandler$1", 1.class, null, null);
                }
            });
        } else if (request.decoderResult().cause() != null) {
            request.decoderResult().cause().printStackTrace();
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        block16: {
            if (cause instanceof Http2Exception.StreamException) {
                Http2Exception.StreamException c = (Http2Exception.StreamException)cause;
                HttpToHttp2ConnectionHandler handler = (HttpToHttp2ConnectionHandler)context.pipeline().get(HttpToHttp2ConnectionHandler.class);
                Http2Connection connection = handler.connection();
                if (cause.getMessage().startsWith("Maximum active streams violated for this endpoint")) {
                    if (this.config.getH2MaxStreamsRefused() == 0) {
                        return;
                    }
                    int streamsRefused = (Integer)context.channel().attr(NettyHttpConstants.STREAMS_REFUSED).get();
                    if (++streamsRefused < this.config.getH2MaxStreamsRefused()) {
                        context.channel().attr(NettyHttpConstants.STREAMS_REFUSED).set((Object)streamsRefused);
                        return;
                    }
                    handler.goAway(context, connection.remote().lastStreamCreated(), Http2Error.ENHANCE_YOUR_CALM.code(), Unpooled.wrappedBuffer((byte[])MAX_STREAMS_REFUSED_MESSAGE.getBytes()), context.channel().newPromise());
                    break block16;
                } else {
                    Http2Stream stream = connection.stream(c.streamId());
                    if (Objects.nonNull(stream)) {
                        stream.close();
                    }
                    return;
                }
            }
            if (cause instanceof IllegalArgumentException) {
                if (context.channel().attr(NettyHttpConstants.THROW_FFDC).get() != null) {
                    context.channel().attr(NettyHttpConstants.THROW_FFDC).set(null);
                } else if (!cause.getMessage().contains("possibly HTTP/0.9")) {
                    FFDCFilter.processException((Throwable)cause, (String)(HttpDispatcherHandler.class.getName() + ".exceptionCaught(ChannelHandlerContext, Throwable)"), (String)"1", (Object)context);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("exceptionCaught encountered an IllegalArgumentException : " + cause), (Object[])new Object[0]);
                }
                this.sendErrorMessage(cause);
                return;
            }
            if (cause instanceof TooLongHttpHeaderException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("exceptionCaught encountered an TooLongHttpHeaderException : " + cause), (Object[])new Object[0]);
                }
                this.sendErrorMessage(cause);
                return;
            }
            if (cause instanceof TimeoutException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The connection closed due to idle timeout", (Object[])new Object[0]);
                }
                if (cause instanceof ReadTimeoutException) {
                    this.sendErrorMessage(cause);
                }
            }
        }
        context.close();
    }

    private void sendErrorMessage(Throwable cause) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sending a 400 for throwable [" + cause + "]"), (Object[])new Object[0]);
        }
        this.loadErrorPage(StatusCodes.BAD_REQUEST.getHttpError());
        HttpUtil.setKeepAlive((HttpMessage)this.errorResponse, (boolean)false);
        this.context.writeAndFlush((Object)this.errorResponse);
    }

    /*
     * WARNING - void declaration
     */
    private void loadErrorPage(HttpError error) {
        HttpErrorPageProvider provider;
        this.errorResponse.setStatus(HttpResponseStatus.valueOf((int)error.getErrorCode()));
        WsByteBuffer[] body = error.getErrorBody();
        if (null != body) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("HttpError returned body of length=" + body.length), (Object[])new Object[0]);
            }
            this.errorResponse.replace(Unpooled.wrappedBuffer((byte[])WsByteBufferUtils.asByteArray((WsByteBuffer[])body)));
            if (HttpUtil.isTransferEncodingChunked((HttpMessage)this.errorResponse)) {
                HttpUtil.setTransferEncodingChunked((HttpMessage)this.errorResponse, (boolean)false);
            }
            HttpUtil.setContentLength((HttpMessage)this.errorResponse, (long)body.length);
            return;
        }
        if (HttpUtil.isTransferEncodingChunked((HttpMessage)this.errorResponse)) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.errorResponse, (boolean)false);
        }
        HttpUtil.setContentLength((HttpMessage)this.errorResponse, (long)0L);
        HttpErrorPageService eps = (HttpErrorPageService)HttpDispatcher.getFramework().lookupService(HttpErrorPageService.class);
        if (null == eps) {
            return;
        }
        InetSocketAddress local = (InetSocketAddress)this.context.channel().localAddress();
        InetSocketAddress remote = (InetSocketAddress)this.context.channel().remoteAddress();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Querying service for port=" + local.getPort()), (Object[])new Object[0]);
        }
        if (null != (provider = eps.access(local.getPort()))) {
            block13: {
                String host = local.getAddress().getHostName();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Querying provider for host=" + host), (Object[])new Object[0]);
                }
                try {
                    body = provider.accessPage(host, local.getPort(), null, null);
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.http.netty.pipeline.inbound.HttpDispatcherHandler", (String)"229", (Object)((Object)this), (Object[])new Object[]{error});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                    Tr.debug((TraceComponent)tc, (String)("Exception while calling into provider, t=" + t), (Object[])new Object[0]);
                }
            }
            if (null != body) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Received body of length=" + body.length), (Object[])new Object[0]);
                }
                this.errorResponse.replace(Unpooled.wrappedBuffer((byte[])WsByteBufferUtils.asByteArray((WsByteBuffer[])body)));
                if (HttpUtil.isTransferEncodingChunked((HttpMessage)this.errorResponse)) {
                    HttpUtil.setTransferEncodingChunked((HttpMessage)this.errorResponse, (boolean)false);
                }
                HttpUtil.setContentLength((HttpMessage)this.errorResponse, (long)body.length);
            }
        }
    }

    public void newRequest(ChannelHandlerContext context, FullHttpRequest request) {
        if (request.headers().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text())) {
            context.channel().attr(NettyHttpConstants.PROTOCOL).set((Object)"HTTP2");
        } else if (request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
            context.channel().attr(NettyHttpConstants.PROTOCOL).set((Object)"HTTP10");
        } else {
            context.channel().attr(NettyHttpConstants.PROTOCOL).set((Object)"http");
        }
        HttpDispatcherLink link = new HttpDispatcherLink();
        if (context.channel().hasAttr(NettyHttpConstants.CONTENT_LENGTH)) {
            context.channel().attr(NettyHttpConstants.CONTENT_LENGTH).set(null);
        }
        int numberOfRequests = (Integer)context.channel().attr(NettyHttpConstants.NUMBER_OF_HTTP_REQUESTS).get();
        context.channel().attr(NettyHttpConstants.NUMBER_OF_HTTP_REQUESTS).set((Object)(numberOfRequests + 1));
        link.init(context, request, this.config);
        link.ready();
    }
}

