/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.services.impl.AbstractThreadPoolServiceImpl;
import com.ibm.jbatch.container.util.BatchContainerConstants;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class BoundedThreadPoolServiceImpl
extends AbstractThreadPoolServiceImpl
implements BatchContainerConstants {
    private static final String sourceClass = BoundedThreadPoolServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private String defaultMaxThreadPoolSize;
    int idleThreadTimeout;
    int maxQueueSize;
    int minThreadPoolSize;
    static final long serialVersionUID = -8445782328104735973L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BoundedThreadPoolServiceImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.BoundedThreadPoolServiceImpl", "<init>", new Object[0]);
        }
        this.defaultMaxThreadPoolSize = "5";
        this.idleThreadTimeout = 900;
        this.maxQueueSize = 4096;
        this.minThreadPoolSize = 3;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.BoundedThreadPoolServiceImpl", "<init>", this);
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        String method = "init";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        String maxThreadPoolSizeStr = batchConfig.getConfigProperties().getProperty("BOUNDED_THREADPOOL_MAX_POOL_SIZE", this.defaultMaxThreadPoolSize);
        int maxThreadPoolSize = Integer.parseInt(maxThreadPoolSizeStr);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Glassfish thread pool settings: (" + this.minThreadPoolSize + "," + maxThreadPoolSize + "," + this.idleThreadTimeout + "," + (Object)((Object)TimeUnit.SECONDS) + "," + this.maxQueueSize + ")");
        }
        LinkedBlockingQueue<Runnable> queue = null;
        queue = this.maxQueueSize == -1 ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(this.maxQueueSize);
        this.executorService = new ThreadPoolExecutor(this.minThreadPoolSize, maxThreadPoolSize, this.idleThreadTimeout, TimeUnit.SECONDS, queue);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }
}

