/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.marshal;

import io.opentelemetry.exporter.internal.marshal.UnsafeAccess;
import java.lang.reflect.Field;

class UnsafeString {
    private static final long valueOffset = UnsafeString.getStringFieldOffset("value", byte[].class);
    private static final long coderOffset = UnsafeString.getStringFieldOffset("coder", Byte.TYPE);
    private static final int byteArrayBaseOffset = UnsafeAccess.isAvailable() ? UnsafeAccess.arrayBaseOffset(byte[].class) : -1;
    private static final boolean available = valueOffset != -1L && coderOffset != -1L;

    static boolean isAvailable() {
        return available;
    }

    static boolean isLatin1(String string) {
        return UnsafeAccess.getByte(string, coderOffset) == 0;
    }

    static byte[] getBytes(String string) {
        return (byte[])UnsafeAccess.getObject(string, valueOffset);
    }

    static long getLong(byte[] bytes, int index) {
        return UnsafeAccess.getLong(bytes, byteArrayBaseOffset + index);
    }

    private static long getStringFieldOffset(String fieldName, Class<?> expectedType) {
        if (!UnsafeAccess.isAvailable()) {
            return -1L;
        }
        try {
            Field field = String.class.getDeclaredField(fieldName);
            if (field.getType() != expectedType) {
                return -1L;
            }
            return UnsafeAccess.objectFieldOffset(field);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private UnsafeString() {
    }
}

