/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ExceptionMatcher {
    private static final String className = ExceptionMatcher.class.getName();
    private static Logger logger = Logger.getLogger(ExceptionMatcher.class.getPackage().getName());
    private List<Object> exceptionHierarchy;
    private Set<String> _skipIncludeExceptions;
    private Set<String> _skipExcludeExceptions;
    static final long serialVersionUID = 5468139443039703073L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExceptionMatcher(Set<String> _skipIncludeExceptions, Set<String> _skipExcludeExceptions) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.ExceptionMatcher", "<init>", new Object[]{_skipIncludeExceptions, _skipExcludeExceptions});
        }
        this._skipIncludeExceptions = _skipIncludeExceptions;
        this._skipExcludeExceptions = _skipExcludeExceptions;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.ExceptionMatcher", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={ClassNotFoundException.class})
    public boolean isSkippableOrRetryable(Exception e) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.ExceptionMatcher", "isSkippableOrRetryable", new Object[]{e});
        }
        String mName = "isSkippableOrRetryable";
        String exClassName = e.getClass().getName();
        boolean retVal = false;
        try {
            int excludeCount;
            int includeCount;
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Class<?> excClass = tccl.loadClass(e.getClass().getName());
            this.exceptionHierarchy = new ArrayList<Object>();
            this.getSuperClasses(excClass);
            boolean inExclude = this.isInElementSet(this._skipExcludeExceptions, excClass);
            boolean inInclude = this.isInElementSet(this._skipIncludeExceptions, excClass);
            retVal = inInclude && inExclude ? ((includeCount = this.getDistanceToElement(this._skipIncludeExceptions)) == (excludeCount = this.getDistanceToElement(this._skipExcludeExceptions)) ? false : includeCount < excludeCount) : inInclude && !inExclude;
        }
        catch (ClassNotFoundException cnf) {
            logger.logp(Level.FINE, className, "isSkippableOrRetryable", cnf.getLocalizedMessage());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "isSkippableOrRetryable", "isSkippableOrRetryable: " + retVal + ": " + exClassName);
        }
        boolean bl = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.impl.ExceptionMatcher", "isSkippableOrRetryable", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isInElementSet(Set<String> skipList, Class<?> excClass) throws ClassNotFoundException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.ExceptionMatcher", "isInElementSet", new Object[]{skipList, excClass});
        }
        boolean retVal = false;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        for (String value : skipList) {
            Class<?> clazz = tccl.loadClass(value);
            if (!clazz.isAssignableFrom(excClass)) continue;
            retVal = true;
            break;
        }
        boolean bl = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.impl.ExceptionMatcher", "isInElementSet", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getDistanceToElement(Set<String> skipList) throws ClassNotFoundException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.ExceptionMatcher", "getDistanceToElement", new Object[]{skipList});
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        int closest = Integer.MAX_VALUE;
        block0: for (String exception : skipList) {
            for (int i = 0; i < this.exceptionHierarchy.size(); ++i) {
                Class<?> exClazz;
                Class clazz = (Class)this.exceptionHierarchy.get(i);
                if (!clazz.equals(exClazz = tccl.loadClass(exception))) continue;
                int count = i;
                if (count >= closest) continue block0;
                closest = count;
                continue block0;
            }
        }
        int n = closest;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.impl.ExceptionMatcher", "getDistanceToElement", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void getSuperClasses(Class<?> objClass) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.ExceptionMatcher", "getSuperClasses", new Object[]{objClass});
        }
        this.exceptionHierarchy.add(objClass);
        this.getSuperClass(objClass);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.ExceptionMatcher", "getSuperClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void getSuperClass(Class<?> objClass) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.ExceptionMatcher", "getSuperClass", new Object[]{objClass});
        }
        Class<?> clazz = objClass.getSuperclass();
        if (clazz != null) {
            this.exceptionHierarchy.add(clazz);
            this.getSuperClass(clazz);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.ExceptionMatcher", "getSuperClass");
        }
    }
}

