/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.authentication;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.authentication.AuthenticationResponseValidator;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.exceptions.AuthenticationResponseException;
import io.openliberty.security.oidcclientcore.storage.CookieBasedStorage;
import io.openliberty.security.oidcclientcore.storage.OidcStorageUtils;
import io.openliberty.security.oidcclientcore.storage.SessionBasedStorage;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JakartaOidcAuthenticationResponseValidator
extends AuthenticationResponseValidator {
    public static final TraceComponent tc = Tr.register(JakartaOidcAuthenticationResponseValidator.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    private final OidcClientConfig oidcClientConfig;
    static final long serialVersionUID = -4156223348783652577L;

    public JakartaOidcAuthenticationResponseValidator(HttpServletRequest request, HttpServletResponse response, OidcClientConfig oidcClientConfig) {
        super(request, response);
        this.oidcClientConfig = oidcClientConfig;
        this.instantiateStorage(oidcClientConfig);
    }

    private void instantiateStorage(OidcClientConfig config) {
        this.storage = this.oidcClientConfig.isUseSession() ? new SessionBasedStorage(this.request) : new CookieBasedStorage(this.request, this.response);
    }

    @Override
    public void validateResponse() throws AuthenticationResponseException {
        String state = this.getAndVerifyStateValue();
        this.checkRequestAgainstRedirectUri(state);
        this.checkForErrorParameter();
    }

    String getAndVerifyStateValue() throws AuthenticationResponseException {
        String stateParameter = this.request.getParameter("state");
        if (stateParameter == null || stateParameter.isEmpty()) {
            String nlsMessage = Tr.formatMessage((TraceComponent)tc, (String)"CALLBACK_MISSING_STATE_PARAMETER", (Object[])new Object[0]);
            throw new AuthenticationResponseException(AuthenticationResponseException.ValidationResult.INVALID_RESULT, this.oidcClientConfig.getClientId(), nlsMessage);
        }
        String clientSecret = null;
        ProtectedString clientSecretProtectedString = this.oidcClientConfig.getClientSecret();
        if (clientSecretProtectedString != null) {
            clientSecret = new String(clientSecretProtectedString.getChars());
        }
        this.verifyState(stateParameter, this.oidcClientConfig.getClientId(), clientSecret, 300L, 420L);
        return stateParameter;
    }

    @Override
    public String getStoredStateValue(String stateParameter) throws AuthenticationResponseException {
        String stateStorageName = OidcStorageUtils.getStateStorageKey(stateParameter);
        String storedState = this.storage.get(stateStorageName);
        if (storedState == null) {
            String nlsMessage = Tr.formatMessage((TraceComponent)tc, (String)"STATE_VALUE_IN_CALLBACK_NOT_STORED", (Object[])new Object[]{stateParameter});
            throw new AuthenticationResponseException(AuthenticationResponseException.ValidationResult.NOT_VALIDATED_RESULT, this.oidcClientConfig.getClientId(), nlsMessage);
        }
        return storedState;
    }

    void checkRequestAgainstRedirectUri(String state) throws AuthenticationResponseException {
        String configuredRedirectUri;
        String requestUrl = this.request.getRequestURL().toString();
        if (requestUrl.equals(configuredRedirectUri = this.oidcClientConfig.getRedirectURI())) {
            return;
        }
        if (this.oidcClientConfig.isRedirectToOriginalResource()) {
            String originalReqUrlWithoutQueryParams;
            String originalReqUrl = this.storage.get(OidcStorageUtils.getOriginalReqUrlStorageKey(state));
            if (originalReqUrl == null) {
                this.throwExceptionForRedirectUriDoesNotMatch(requestUrl, originalReqUrl);
            }
            if (!(originalReqUrlWithoutQueryParams = originalReqUrl.split(Pattern.quote("?"))[0]).equals(requestUrl)) {
                this.throwExceptionForRedirectUriDoesNotMatch(requestUrl, originalReqUrlWithoutQueryParams);
            }
            return;
        }
        this.throwExceptionForRedirectUriDoesNotMatch(requestUrl, configuredRedirectUri);
    }

    void throwExceptionForRedirectUriDoesNotMatch(String requestUrl, String expectedUrl) throws AuthenticationResponseException {
        String nlsMessage = Tr.formatMessage((TraceComponent)tc, (String)"CALLBACK_URL_DOES_NOT_MATCH_REDIRECT_URI", (Object[])new Object[]{requestUrl, expectedUrl, this.oidcClientConfig.getClientId()});
        throw new AuthenticationResponseException(AuthenticationResponseException.ValidationResult.NOT_VALIDATED_RESULT, this.oidcClientConfig.getClientId(), nlsMessage);
    }

    void checkForErrorParameter() throws AuthenticationResponseException {
        String errorParameter = this.request.getParameter("error");
        if (errorParameter != null) {
            String nlsMessage = Tr.formatMessage((TraceComponent)tc, (String)"CALLBACK_URL_INCLUDES_ERROR_PARAMETER", (Object[])new Object[]{errorParameter});
            throw new AuthenticationResponseException(AuthenticationResponseException.ValidationResult.INVALID_RESULT, this.oidcClientConfig.getClientId(), nlsMessage);
        }
    }
}

