/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.csi;

import org.apache.yoko.orb.csi.gssup.GSSUPPolicyValue;
import org.apache.yoko.orb.csi.gssup.GSSUPPolicyValueHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.Security.DelegationDirective;
import org.omg.Security.DelegationDirectiveHelper;
import org.omg.Security.EstablishTrust;
import org.omg.Security.EstablishTrustHelper;
import org.omg.Security.MechanismTypeListHelper;
import org.omg.Security.QOP;
import org.omg.Security.QOPHelper;
import org.omg.Security.RequiresSupports;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.CredentialsListHelper;

class CSIPolicyFactory
extends LocalObject
implements PolicyFactory {
    CSIPolicyFactory() {
    }

    public Policy create_policy(int type, Any value) throws PolicyError {
        switch (type) {
            case 12: {
                return new MechanismPolicy(value);
            }
            case 13: {
                return new InvocationCredentialsPolicy(value);
            }
            case 15: {
                return new QOPPolicy(value);
            }
            case 39: {
                return new EstablishTrustPolicy(value);
            }
            case 38: {
                return new DelegationDirectivePolicy(value);
            }
            case 8080: {
                return new GSSUPPolicy(value);
            }
        }
        throw new PolicyError(0);
    }

    static class GSSUPPolicy
    extends SecurityPolicy
    implements org.apache.yoko.orb.csi.gssup.GSSUPPolicy {
        RequiresSupports mode;
        String domain;

        GSSUPPolicy(Any value) {
            GSSUPPolicyValue val = GSSUPPolicyValueHelper.extract(value);
            this.mode = val.mode;
            this.domain = val.domain;
        }

        public int policy_type() {
            return 8080;
        }

        @Override
        public RequiresSupports mode() {
            return this.mode;
        }

        @Override
        public String domain() {
            return this.domain;
        }
    }

    static class DelegationDirectivePolicy
    extends SecurityPolicy
    implements org.omg.SecurityLevel2.DelegationDirectivePolicy {
        DelegationDirective directive;

        DelegationDirectivePolicy(Any value) {
            this.directive = DelegationDirectiveHelper.extract((Any)value);
        }

        public int policy_type() {
            return 38;
        }

        public DelegationDirective delegation_directive() {
            return this.directive;
        }
    }

    static class EstablishTrustPolicy
    extends SecurityPolicy
    implements org.omg.SecurityLevel2.EstablishTrustPolicy {
        EstablishTrust trust;

        EstablishTrustPolicy(Any value) {
            this.trust = EstablishTrustHelper.extract((Any)value);
        }

        public int policy_type() {
            return 39;
        }

        public EstablishTrust trust() {
            return this.trust;
        }
    }

    static class QOPPolicy
    extends SecurityPolicy
    implements org.omg.SecurityLevel2.QOPPolicy {
        QOP qop;

        QOPPolicy(Any value) {
            this.qop = QOPHelper.extract((Any)value);
        }

        public int policy_type() {
            return 15;
        }

        public QOP qop() {
            return this.qop;
        }
    }

    static class InvocationCredentialsPolicy
    extends SecurityPolicy
    implements org.omg.SecurityLevel2.InvocationCredentialsPolicy {
        Credentials[] creds;

        InvocationCredentialsPolicy(Any value) {
            this.creds = CredentialsListHelper.extract((Any)value);
        }

        public int policy_type() {
            return 13;
        }

        public Credentials[] creds() {
            return this.creds;
        }
    }

    static class MechanismPolicy
    extends SecurityPolicy
    implements org.omg.SecurityLevel2.MechanismPolicy {
        String[] mechanisms;

        MechanismPolicy(Any value) {
            this.mechanisms = MechanismTypeListHelper.extract((Any)value);
        }

        public int policy_type() {
            return 12;
        }

        public String[] mechanisms() {
            return this.mechanisms;
        }
    }

    static abstract class SecurityPolicy
    extends LocalObject
    implements Policy,
    Cloneable {
        SecurityPolicy() {
        }

        public Policy copy() {
            try {
                return (Policy)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        public void destroy() {
        }
    }
}

