/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.model;

import jakarta.faces.model.DataModelListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class DataModel<E>
implements Iterable<E> {
    private static final DataModelListener[] EMPTY_DATA_MODEL_LISTENER = new DataModelListener[0];
    private List<DataModelListener> _listeners;
    private DataModelListener[] _cachedListenersArray = null;

    public void addDataModelListener(DataModelListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this._listeners == null) {
            this._listeners = new ArrayList<DataModelListener>();
        }
        this._listeners.add(listener);
        this._cachedListenersArray = null;
    }

    public DataModelListener[] getDataModelListeners() {
        if (this._listeners == null) {
            return EMPTY_DATA_MODEL_LISTENER;
        }
        if (this._cachedListenersArray == null) {
            this._cachedListenersArray = this._listeners.toArray(new DataModelListener[this._listeners.size()]);
        }
        return this._cachedListenersArray;
    }

    public abstract int getRowCount();

    public abstract E getRowData();

    public abstract int getRowIndex();

    public abstract Object getWrappedData();

    public abstract boolean isRowAvailable();

    @Override
    public Iterator<E> iterator() {
        return new DataModelIterator();
    }

    public void removeDataModelListener(DataModelListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
        this._cachedListenersArray = null;
    }

    public abstract void setRowIndex(int var1);

    public abstract void setWrappedData(Object var1);

    private class DataModelIterator
    implements Iterator<E> {
        private int nextRowIndex = 0;

        public DataModelIterator() {
            DataModel.this.setRowIndex(this.nextRowIndex);
        }

        @Override
        public boolean hasNext() {
            return DataModel.this.isRowAvailable();
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                Object data = DataModel.this.getRowData();
                ++this.nextRowIndex;
                DataModel.this.setRowIndex(this.nextRowIndex);
                return data;
            }
            throw new NoSuchElementException("Couldn't find any element in DataModel at index " + this.nextRowIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

