/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.exception;

import jakarta.annotation.CheckForNull;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.concurrent.Immutable;
import org.shredzone.acme4j.Problem;
import org.shredzone.acme4j.exception.AcmeServerException;

@ParametersAreNonnullByDefault
@Immutable
public class AcmeRateLimitedException
extends AcmeServerException {
    private static final long serialVersionUID = 4150484059796413069L;
    private final Instant retryAfter;
    private final Collection<URL> documents;

    public AcmeRateLimitedException(Problem problem, @Nullable Instant retryAfter, @Nullable Collection<URL> documents) {
        super(problem);
        this.retryAfter = retryAfter;
        this.documents = documents != null ? Collections.unmodifiableCollection(documents) : null;
    }

    @CheckForNull
    public Instant getRetryAfter() {
        return this.retryAfter;
    }

    @CheckForNull
    public Collection<URL> getDocuments() {
        return this.documents;
    }
}

