/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableCollection;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableListMultimap;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.com.google.common.collect.ImmutableSet;
import graphql.execution.AbortExecutionException;
import graphql.execution.CoercedVariables;
import graphql.execution.MergedField;
import graphql.execution.RawVariables;
import graphql.execution.ValuesResolver;
import graphql.execution.conditional.ConditionalNodes;
import graphql.execution.directives.QueryDirectives;
import graphql.execution.directives.QueryDirectivesImpl;
import graphql.introspection.Introspection;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.NodeUtil;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.VariableDefinition;
import graphql.normalized.ENFMerger;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.ExecutableNormalizedOperation;
import graphql.normalized.NormalizedInputValue;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.impl.SchemaUtil;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class ExecutableNormalizedOperationFactory {
    private static final ConditionalNodes conditionalNodes = new ConditionalNodes();

    private ExecutableNormalizedOperationFactory() {
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperation(GraphQLSchema graphQLSchema, Document document, String operationName, CoercedVariables coercedVariableValues) {
        return ExecutableNormalizedOperationFactory.createExecutableNormalizedOperation(graphQLSchema, document, operationName, coercedVariableValues, Options.defaultOptions());
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperation(GraphQLSchema graphQLSchema, Document document, String operationName, CoercedVariables coercedVariableValues, Options options) {
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, operationName);
        return new ExecutableNormalizedOperationFactoryImpl(graphQLSchema, getOperationResult.operationDefinition, getOperationResult.fragmentsByName, coercedVariableValues, null, options).createNormalizedQueryImpl();
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperation(GraphQLSchema graphQLSchema, OperationDefinition operationDefinition, Map<String, FragmentDefinition> fragments, CoercedVariables coercedVariableValues) {
        return ExecutableNormalizedOperationFactory.createExecutableNormalizedOperation(graphQLSchema, operationDefinition, fragments, coercedVariableValues, Options.defaultOptions());
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperation(GraphQLSchema graphQLSchema, OperationDefinition operationDefinition, Map<String, FragmentDefinition> fragments, CoercedVariables coercedVariableValues, Options options) {
        return new ExecutableNormalizedOperationFactoryImpl(graphQLSchema, operationDefinition, fragments, coercedVariableValues, null, options).createNormalizedQueryImpl();
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperationWithRawVariables(GraphQLSchema graphQLSchema, Document document, String operationName, RawVariables rawVariables) {
        return ExecutableNormalizedOperationFactory.createExecutableNormalizedOperationWithRawVariables(graphQLSchema, document, operationName, rawVariables, Options.defaultOptions());
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperationWithRawVariables(GraphQLSchema graphQLSchema, Document document, String operationName, RawVariables rawVariables, GraphQLContext graphQLContext, Locale locale) {
        return ExecutableNormalizedOperationFactory.createExecutableNormalizedOperationWithRawVariables(graphQLSchema, document, operationName, rawVariables, Options.defaultOptions().graphQLContext(graphQLContext).locale(locale));
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperationWithRawVariables(GraphQLSchema graphQLSchema, Document document, String operationName, RawVariables rawVariables, Options options) {
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, operationName);
        OperationDefinition operationDefinition = getOperationResult.operationDefinition;
        List<VariableDefinition> variableDefinitions = operationDefinition.getVariableDefinitions();
        CoercedVariables coercedVariableValues = ValuesResolver.coerceVariableValues(graphQLSchema, variableDefinitions, rawVariables, options.getGraphQLContext(), options.getLocale());
        Map<String, NormalizedInputValue> normalizedVariableValues = ValuesResolver.getNormalizedVariableValues(graphQLSchema, variableDefinitions, rawVariables, options.getGraphQLContext(), options.getLocale());
        return new ExecutableNormalizedOperationFactoryImpl(graphQLSchema, operationDefinition, getOperationResult.fragmentsByName, coercedVariableValues, normalizedVariableValues, options).createNormalizedQueryImpl();
    }

    private static class ExecutableNormalizedOperationFactoryImpl {
        private final GraphQLSchema graphQLSchema;
        private final OperationDefinition operationDefinition;
        private final Map<String, FragmentDefinition> fragments;
        private final CoercedVariables coercedVariableValues;
        @Nullable
        private final Map<String, NormalizedInputValue> normalizedVariableValues;
        private final Options options;
        private final List<PossibleMerger> possibleMergerList = new ArrayList<PossibleMerger>();
        private final ImmutableListMultimap.Builder<Field, ExecutableNormalizedField> fieldToNormalizedField = ImmutableListMultimap.builder();
        private final ImmutableMap.Builder<ExecutableNormalizedField, MergedField> normalizedFieldToMergedField = ImmutableMap.builder();
        private final ImmutableMap.Builder<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives = ImmutableMap.builder();
        private final ImmutableListMultimap.Builder<FieldCoordinates, ExecutableNormalizedField> coordinatesToNormalizedFields = ImmutableListMultimap.builder();
        private int fieldCount = 0;
        private int maxDepthSeen = 0;

        private ExecutableNormalizedOperationFactoryImpl(GraphQLSchema graphQLSchema, OperationDefinition operationDefinition, Map<String, FragmentDefinition> fragments, CoercedVariables coercedVariableValues, @Nullable Map<String, NormalizedInputValue> normalizedVariableValues, Options options) {
            this.graphQLSchema = graphQLSchema;
            this.operationDefinition = operationDefinition;
            this.fragments = fragments;
            this.coercedVariableValues = coercedVariableValues;
            this.normalizedVariableValues = normalizedVariableValues;
            this.options = options;
        }

        private ExecutableNormalizedOperation createNormalizedQueryImpl() {
            GraphQLObjectType rootType = SchemaUtil.getOperationRootType(this.graphQLSchema, this.operationDefinition);
            CollectNFResult collectFromOperationResult = this.collectFromOperation(rootType);
            for (ExecutableNormalizedField topLevel : collectFromOperationResult.children) {
                ImmutableCollection fieldAndAstParents = collectFromOperationResult.normalizedFieldToAstFields.get(topLevel);
                MergedField mergedField = ExecutableNormalizedOperationFactoryImpl.newMergedField((ImmutableList<FieldAndAstParent>)fieldAndAstParents);
                this.captureMergedField(topLevel, mergedField);
                this.updateFieldToNFMap(topLevel, (ImmutableList<FieldAndAstParent>)fieldAndAstParents);
                this.updateCoordinatedToNFMap(topLevel);
                int depthSeen = this.buildFieldWithChildren(topLevel, (ImmutableList<FieldAndAstParent>)fieldAndAstParents, 1);
                this.maxDepthSeen = Math.max(this.maxDepthSeen, depthSeen);
            }
            for (PossibleMerger possibleMerger : this.possibleMergerList) {
                List<ExecutableNormalizedField> childrenWithSameResultKey = possibleMerger.parent.getChildrenWithSameResultKey(possibleMerger.resultKey);
                ENFMerger.merge(possibleMerger.parent, childrenWithSameResultKey, this.graphQLSchema);
            }
            return new ExecutableNormalizedOperation(this.operationDefinition.getOperation(), this.operationDefinition.getName(), new ArrayList<ExecutableNormalizedField>(collectFromOperationResult.children), (ImmutableListMultimap<Field, ExecutableNormalizedField>)this.fieldToNormalizedField.build(), this.normalizedFieldToMergedField.build(), this.normalizedFieldToQueryDirectives.build(), (ImmutableListMultimap<FieldCoordinates, ExecutableNormalizedField>)this.coordinatesToNormalizedFields.build(), this.fieldCount, this.maxDepthSeen);
        }

        private void captureMergedField(ExecutableNormalizedField enf, MergedField mergedFld) {
            QueryDirectivesImpl queryDirectives = new QueryDirectivesImpl(mergedFld, this.graphQLSchema, this.coercedVariableValues.toMap(), this.options.getGraphQLContext(), this.options.getLocale());
            this.normalizedFieldToQueryDirectives.put(enf, queryDirectives);
            this.normalizedFieldToMergedField.put(enf, mergedFld);
        }

        private int buildFieldWithChildren(ExecutableNormalizedField executableNormalizedField, ImmutableList<FieldAndAstParent> fieldAndAstParents, int curLevel) {
            this.checkMaxDepthExceeded(curLevel);
            CollectNFResult nextLevel = this.collectFromMergedField(executableNormalizedField, fieldAndAstParents, curLevel + 1);
            int maxDepthSeen = curLevel;
            for (ExecutableNormalizedField childENF : nextLevel.children) {
                executableNormalizedField.addChild(childENF);
                ImmutableCollection childFieldAndAstParents = nextLevel.normalizedFieldToAstFields.get(childENF);
                MergedField mergedField = ExecutableNormalizedOperationFactoryImpl.newMergedField((ImmutableList<FieldAndAstParent>)childFieldAndAstParents);
                this.captureMergedField(childENF, mergedField);
                this.updateFieldToNFMap(childENF, (ImmutableList<FieldAndAstParent>)childFieldAndAstParents);
                this.updateCoordinatedToNFMap(childENF);
                int depthSeen = this.buildFieldWithChildren(childENF, (ImmutableList<FieldAndAstParent>)childFieldAndAstParents, curLevel + 1);
                maxDepthSeen = Math.max(maxDepthSeen, depthSeen);
                this.checkMaxDepthExceeded(maxDepthSeen);
            }
            return maxDepthSeen;
        }

        private void checkMaxDepthExceeded(int depthSeen) {
            if (depthSeen > this.options.getMaxChildrenDepth()) {
                throw new AbortExecutionException("Maximum query depth exceeded. " + depthSeen + " > " + this.options.getMaxChildrenDepth());
            }
        }

        private static MergedField newMergedField(ImmutableList<FieldAndAstParent> fieldAndAstParents) {
            return MergedField.newMergedField(ImmutableKit.map(fieldAndAstParents, fieldAndAstParent -> fieldAndAstParent.field)).build();
        }

        private void updateFieldToNFMap(ExecutableNormalizedField executableNormalizedField, ImmutableList<FieldAndAstParent> mergedField) {
            for (FieldAndAstParent astField : mergedField) {
                this.fieldToNormalizedField.put((Object)astField.field, (Object)executableNormalizedField);
            }
        }

        private void updateCoordinatedToNFMap(ExecutableNormalizedField topLevel) {
            for (String objectType : topLevel.getObjectTypeNames()) {
                FieldCoordinates coordinates = FieldCoordinates.coordinates(objectType, topLevel.getFieldName());
                this.coordinatesToNormalizedFields.put((Object)coordinates, (Object)topLevel);
            }
        }

        public CollectNFResult collectFromMergedField(ExecutableNormalizedField executableNormalizedField, ImmutableList<FieldAndAstParent> mergedField, int level) {
            List<GraphQLFieldDefinition> fieldDefs = executableNormalizedField.getFieldDefinitions(this.graphQLSchema);
            ImmutableSet<GraphQLObjectType> possibleObjects = this.resolvePossibleObjects(fieldDefs);
            if (possibleObjects.isEmpty()) {
                return new CollectNFResult(ImmutableKit.emptyList(), ImmutableListMultimap.of());
            }
            ArrayList<CollectedField> collectedFields = new ArrayList<CollectedField>();
            for (FieldAndAstParent fieldAndAstParent : mergedField) {
                if (fieldAndAstParent.field.getSelectionSet() == null) continue;
                GraphQLFieldDefinition fieldDefinition = Introspection.getFieldDef(this.graphQLSchema, fieldAndAstParent.astParentType, fieldAndAstParent.field.getName());
                GraphQLUnmodifiedType astParentType = GraphQLTypeUtil.unwrapAll(fieldDefinition.getType());
                this.collectFromSelectionSet(fieldAndAstParent.field.getSelectionSet(), collectedFields, (GraphQLCompositeType)((Object)astParentType), possibleObjects);
            }
            Map<String, List<CollectedField>> fieldsByName = this.fieldsByResultKey(collectedFields);
            ImmutableList.Builder<ExecutableNormalizedField> resultNFs = ImmutableList.builder();
            ImmutableListMultimap.Builder<ExecutableNormalizedField, FieldAndAstParent> normalizedFieldToAstFields = ImmutableListMultimap.builder();
            this.createNFs(resultNFs, fieldsByName, normalizedFieldToAstFields, level, executableNormalizedField);
            return new CollectNFResult(resultNFs.build(), (ImmutableListMultimap<ExecutableNormalizedField, FieldAndAstParent>)normalizedFieldToAstFields.build());
        }

        private Map<String, List<CollectedField>> fieldsByResultKey(List<CollectedField> collectedFields) {
            LinkedHashMap<String, List<CollectedField>> fieldsByName = new LinkedHashMap<String, List<CollectedField>>();
            for (CollectedField collectedField : collectedFields) {
                fieldsByName.computeIfAbsent(collectedField.field.getResultKey(), ignored -> new ArrayList()).add(collectedField);
            }
            return fieldsByName;
        }

        public CollectNFResult collectFromOperation(GraphQLObjectType rootType) {
            ImmutableSet<GraphQLObjectType> possibleObjects = ImmutableSet.of(rootType);
            ArrayList<CollectedField> collectedFields = new ArrayList<CollectedField>();
            this.collectFromSelectionSet(this.operationDefinition.getSelectionSet(), collectedFields, rootType, possibleObjects);
            Map<String, List<CollectedField>> fieldsByName = this.fieldsByResultKey(collectedFields);
            ImmutableList.Builder<ExecutableNormalizedField> resultNFs = ImmutableList.builder();
            ImmutableListMultimap.Builder<ExecutableNormalizedField, FieldAndAstParent> normalizedFieldToAstFields = ImmutableListMultimap.builder();
            this.createNFs(resultNFs, fieldsByName, normalizedFieldToAstFields, 1, null);
            return new CollectNFResult(resultNFs.build(), (ImmutableListMultimap<ExecutableNormalizedField, FieldAndAstParent>)normalizedFieldToAstFields.build());
        }

        private void createNFs(ImmutableList.Builder<ExecutableNormalizedField> nfListBuilder, Map<String, List<CollectedField>> fieldsByName, ImmutableListMultimap.Builder<ExecutableNormalizedField, FieldAndAstParent> normalizedFieldToAstFields, int level, ExecutableNormalizedField parent) {
            for (String resultKey : fieldsByName.keySet()) {
                List<CollectedField> fieldsWithSameResultKey = fieldsByName.get(resultKey);
                List<CollectedFieldGroup> commonParentsGroups = this.groupByCommonParents(fieldsWithSameResultKey);
                for (CollectedFieldGroup fieldGroup : commonParentsGroups) {
                    ExecutableNormalizedField nf = this.createNF(fieldGroup, level, parent);
                    if (nf == null) continue;
                    for (CollectedField collectedField : fieldGroup.fields) {
                        normalizedFieldToAstFields.put((Object)nf, (Object)new FieldAndAstParent(collectedField.field, collectedField.astTypeCondition));
                    }
                    nfListBuilder.add((Object)nf);
                }
                if (commonParentsGroups.size() <= 1) continue;
                this.possibleMergerList.add(new PossibleMerger(parent, resultKey));
            }
        }

        private ExecutableNormalizedField createNF(CollectedFieldGroup collectedFieldGroup, int level, ExecutableNormalizedField parent) {
            ++this.fieldCount;
            if (this.fieldCount > this.options.getMaxFieldsCount()) {
                throw new AbortExecutionException("Maximum field count exceeded. " + this.fieldCount + " > " + this.options.getMaxFieldsCount());
            }
            Set<GraphQLObjectType> objectTypes = collectedFieldGroup.objectTypes;
            Field field = collectedFieldGroup.fields.iterator().next().field;
            String fieldName = field.getName();
            GraphQLFieldDefinition fieldDefinition = Introspection.getFieldDef(this.graphQLSchema, objectTypes.iterator().next(), fieldName);
            Map<String, Object> argumentValues = ValuesResolver.getArgumentValues(fieldDefinition.getArguments(), field.getArguments(), CoercedVariables.of(this.coercedVariableValues.toMap()), this.options.graphQLContext, this.options.locale);
            Map<String, NormalizedInputValue> normalizedArgumentValues = null;
            if (this.normalizedVariableValues != null) {
                normalizedArgumentValues = ValuesResolver.getNormalizedArgumentValues(fieldDefinition.getArguments(), field.getArguments(), this.normalizedVariableValues);
            }
            ImmutableList<String> objectTypeNames = ImmutableKit.map(objectTypes, GraphQLObjectType::getName);
            return ExecutableNormalizedField.newNormalizedField().alias(field.getAlias()).resolvedArguments(argumentValues).normalizedArguments(normalizedArgumentValues).astArguments(field.getArguments()).objectTypeNames(objectTypeNames).fieldName(fieldName).level(level).parent(parent).build();
        }

        private List<CollectedFieldGroup> groupByCommonParents(Collection<CollectedField> fields) {
            return this.groupByCommonParentsNoDeferSupport(fields);
        }

        private List<CollectedFieldGroup> groupByCommonParentsNoDeferSupport(Collection<CollectedField> fields) {
            ImmutableSet.Builder objectTypes = ImmutableSet.builder();
            for (CollectedField collectedField : fields) {
                objectTypes.addAll(collectedField.objectTypes);
            }
            ImmutableCollection allRelevantObjects = objectTypes.build();
            Map<GraphQLType, ImmutableList<CollectedField>> groupByAstParent = FpKit.groupingBy(fields, fieldAndType -> fieldAndType.astTypeCondition);
            if (groupByAstParent.size() == 1) {
                return Collections.singletonList(new CollectedFieldGroup(ImmutableSet.copyOf(fields), (Set<GraphQLObjectType>)((Object)allRelevantObjects)));
            }
            ImmutableList.Builder result = ImmutableList.builder();
            for (GraphQLObjectType objectType : allRelevantObjects) {
                Set<CollectedField> relevantFields = FpKit.filterSet(fields, field -> field.objectTypes.contains(objectType));
                result.add(new CollectedFieldGroup(relevantFields, Collections.singleton(objectType)));
            }
            return result.build();
        }

        private void collectFromSelectionSet(SelectionSet selectionSet, List<CollectedField> result, GraphQLCompositeType astTypeCondition, Set<GraphQLObjectType> possibleObjects) {
            for (Selection selection : selectionSet.getSelections()) {
                if (selection instanceof Field) {
                    this.collectField(result, (Field)selection, possibleObjects, astTypeCondition);
                    continue;
                }
                if (selection instanceof InlineFragment) {
                    this.collectInlineFragment(result, (InlineFragment)selection, possibleObjects, astTypeCondition);
                    continue;
                }
                if (!(selection instanceof FragmentSpread)) continue;
                this.collectFragmentSpread(result, (FragmentSpread)selection, possibleObjects);
            }
        }

        private void collectFragmentSpread(List<CollectedField> result, FragmentSpread fragmentSpread, Set<GraphQLObjectType> possibleObjects) {
            if (!conditionalNodes.shouldInclude(fragmentSpread, this.coercedVariableValues.toMap(), this.graphQLSchema, this.options.graphQLContext)) {
                return;
            }
            FragmentDefinition fragmentDefinition = Assert.assertNotNull(this.fragments.get(fragmentSpread.getName()));
            if (!conditionalNodes.shouldInclude(fragmentDefinition, this.coercedVariableValues.toMap(), this.graphQLSchema, this.options.graphQLContext)) {
                return;
            }
            GraphQLCompositeType newAstTypeCondition = (GraphQLCompositeType)Assert.assertNotNull(this.graphQLSchema.getType(fragmentDefinition.getTypeCondition().getName()));
            Set<GraphQLObjectType> newPossibleObjects = this.narrowDownPossibleObjects(possibleObjects, newAstTypeCondition);
            this.collectFromSelectionSet(fragmentDefinition.getSelectionSet(), result, newAstTypeCondition, newPossibleObjects);
        }

        private void collectInlineFragment(List<CollectedField> result, InlineFragment inlineFragment, Set<GraphQLObjectType> possibleObjects, GraphQLCompositeType astTypeCondition) {
            if (!conditionalNodes.shouldInclude(inlineFragment, this.coercedVariableValues.toMap(), this.graphQLSchema, this.options.graphQLContext)) {
                return;
            }
            Set<GraphQLObjectType> newPossibleObjects = possibleObjects;
            GraphQLCompositeType newAstTypeCondition = astTypeCondition;
            if (inlineFragment.getTypeCondition() != null) {
                newAstTypeCondition = (GraphQLCompositeType)this.graphQLSchema.getType(inlineFragment.getTypeCondition().getName());
                newPossibleObjects = this.narrowDownPossibleObjects(possibleObjects, newAstTypeCondition);
            }
            this.collectFromSelectionSet(inlineFragment.getSelectionSet(), result, newAstTypeCondition, newPossibleObjects);
        }

        private void collectField(List<CollectedField> result, Field field, Set<GraphQLObjectType> possibleObjectTypes, GraphQLCompositeType astTypeCondition) {
            if (!conditionalNodes.shouldInclude(field, this.coercedVariableValues.toMap(), this.graphQLSchema, this.options.graphQLContext)) {
                return;
            }
            if (possibleObjectTypes.isEmpty()) {
                return;
            }
            result.add(new CollectedField(field, possibleObjectTypes, astTypeCondition));
        }

        private Set<GraphQLObjectType> narrowDownPossibleObjects(Set<GraphQLObjectType> currentOnes, GraphQLCompositeType typeCondition) {
            ImmutableSet<GraphQLObjectType> resolvedTypeCondition = this.resolvePossibleObjects(typeCondition);
            if (currentOnes.isEmpty()) {
                return resolvedTypeCondition;
            }
            return FpKit.intersection(currentOnes, resolvedTypeCondition);
        }

        private ImmutableSet<GraphQLObjectType> resolvePossibleObjects(List<GraphQLFieldDefinition> defs) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (GraphQLFieldDefinition def : defs) {
                GraphQLUnmodifiedType outputType = GraphQLTypeUtil.unwrapAll(def.getType());
                if (!(outputType instanceof GraphQLCompositeType)) continue;
                builder.addAll(this.resolvePossibleObjects((GraphQLCompositeType)((Object)outputType)));
            }
            return builder.build();
        }

        private ImmutableSet<GraphQLObjectType> resolvePossibleObjects(GraphQLCompositeType type) {
            if (type instanceof GraphQLObjectType) {
                return ImmutableSet.of((GraphQLObjectType)type);
            }
            if (type instanceof GraphQLInterfaceType) {
                return ImmutableSet.copyOf(this.graphQLSchema.getImplementations((GraphQLInterfaceType)type));
            }
            if (type instanceof GraphQLUnionType) {
                List<GraphQLNamedOutputType> unionTypes = ((GraphQLUnionType)type).getTypes();
                return ImmutableSet.copyOf(ImmutableKit.map(unionTypes, GraphQLObjectType.class::cast));
            }
            return (ImmutableSet)Assert.assertShouldNeverHappen();
        }

        private static class CollectedFieldGroup {
            Set<GraphQLObjectType> objectTypes;
            Set<CollectedField> fields;

            public CollectedFieldGroup(Set<CollectedField> fields, Set<GraphQLObjectType> objectTypes) {
                this.fields = fields;
                this.objectTypes = objectTypes;
            }
        }

        private static class FieldAndAstParent {
            final Field field;
            final GraphQLCompositeType astParentType;

            private FieldAndAstParent(Field field, GraphQLCompositeType astParentType) {
                this.field = field;
                this.astParentType = astParentType;
            }
        }

        public static class CollectNFResult {
            private final Collection<ExecutableNormalizedField> children;
            private final ImmutableListMultimap<ExecutableNormalizedField, FieldAndAstParent> normalizedFieldToAstFields;

            public CollectNFResult(Collection<ExecutableNormalizedField> children, ImmutableListMultimap<ExecutableNormalizedField, FieldAndAstParent> normalizedFieldToAstFields) {
                this.children = children;
                this.normalizedFieldToAstFields = normalizedFieldToAstFields;
            }
        }

        private static class CollectedField {
            Field field;
            Set<GraphQLObjectType> objectTypes;
            GraphQLCompositeType astTypeCondition;

            public CollectedField(Field field, Set<GraphQLObjectType> objectTypes, GraphQLCompositeType astTypeCondition) {
                this.field = field;
                this.objectTypes = objectTypes;
                this.astTypeCondition = astTypeCondition;
            }
        }

        private static class PossibleMerger {
            ExecutableNormalizedField parent;
            String resultKey;

            public PossibleMerger(ExecutableNormalizedField parent, String resultKey) {
                this.parent = parent;
                this.resultKey = resultKey;
            }
        }
    }

    public static class Options {
        private final GraphQLContext graphQLContext;
        private final Locale locale;
        private final int maxChildrenDepth;
        private final int maxFieldsCount;

        private Options(GraphQLContext graphQLContext, Locale locale, int maxChildrenDepth, int maxFieldsCount) {
            this.graphQLContext = graphQLContext;
            this.locale = locale;
            this.maxChildrenDepth = maxChildrenDepth;
            this.maxFieldsCount = maxFieldsCount;
        }

        public static Options defaultOptions() {
            return new Options(GraphQLContext.getDefault(), Locale.getDefault(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Options locale(Locale locale) {
            return new Options(this.graphQLContext, locale, this.maxChildrenDepth, this.maxFieldsCount);
        }

        public Options graphQLContext(GraphQLContext graphQLContext) {
            return new Options(graphQLContext, this.locale, this.maxChildrenDepth, this.maxFieldsCount);
        }

        public Options maxChildrenDepth(int maxChildrenDepth) {
            return new Options(this.graphQLContext, this.locale, maxChildrenDepth, this.maxFieldsCount);
        }

        public Options maxFieldsCount(int maxFieldsCount) {
            return new Options(this.graphQLContext, this.locale, this.maxChildrenDepth, maxFieldsCount);
        }

        public GraphQLContext getGraphQLContext() {
            return this.graphQLContext;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public int getMaxChildrenDepth() {
            return this.maxChildrenDepth;
        }

        public int getMaxFieldsCount() {
            return this.maxFieldsCount;
        }
    }
}

