/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.NoSuchElementException;

public class Queue {
    private volatile Object[] m_array;
    private volatile int m_head = 0;
    private volatile int m_tail = 0;
    private static final TraceComponent tc = SibTr.register(Queue.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public Queue() {
        this.m_array = new Object[4];
    }

    public Queue(int initial_size) {
        if (initial_size < 1) {
            initial_size = 3;
        }
        this.m_array = new Object[initial_size + 1];
    }

    public final boolean isEmpty() {
        return this.m_head == this.m_tail;
    }

    public final void makeEmpty() {
        this.m_head = this.m_tail;
    }

    public final void makeEmptyAndClean() {
        this.makeEmpty();
        for (int i = 0; i < this.m_array.length; ++i) {
            this.m_array[i] = null;
        }
    }

    public final int size() {
        int result;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"size");
        }
        int n = result = this.m_tail >= this.m_head ? this.m_tail - this.m_head : this.m_array.length - this.m_head + this.m_tail;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"size", (Object)new Integer(result));
        }
        return result;
    }

    public final void enqueue(Object obj) {
        this.m_array[this.m_tail++] = obj;
        if (this.m_tail == this.m_array.length) {
            this.m_tail = 0;
        }
        if (this.m_head == this.m_tail) {
            this.expand_array();
        }
    }

    public final Object dequeue() throws NoSuchElementException {
        if (this.m_head == this.m_tail) {
            throw new NoSuchElementException();
        }
        Object obj = this.m_array[this.m_head];
        this.m_array[this.m_head++] = null;
        if (this.m_head == this.m_array.length) {
            this.m_head = 0;
        }
        return obj;
    }

    public final Object peek() throws NoSuchElementException {
        if (this.m_head == this.m_tail) {
            throw new NoSuchElementException();
        }
        return this.m_array[this.m_head];
    }

    private final void expand_array() {
        int length = this.m_array.length;
        Object[] m_new = new Object[length * 2];
        System.arraycopy(this.m_array, this.m_head, m_new, this.m_head, length - this.m_head);
        System.arraycopy(this.m_array, 0, m_new, length, this.m_tail);
        this.m_tail += length;
        this.m_array = m_new;
    }
}

